/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.spring.product;

import com.atlassian.audit.api.AuditService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.tunnel.audit.DefaultTunnelAuditService;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.atlassian.tunnel.cluster.JiraNodeIdProvider;
import com.atlassian.tunnel.cluster.NodeIdProvider;
import com.atlassian.tunnel.properties.DefaultTunnelProperties;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.tunnel.web.loopsprevention.SeraphRedirectsLoopPreventer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={JiraOnly.class})
public class JiraConfiguration {
    @Bean
    public ClusterManager clusterManager() {
        return OsgiServices.importOsgiService(ClusterManager.class);
    }

    @Bean
    public NodeIdProvider jiraNodeIdProvider(ClusterManager clusterManager) {
        return new JiraNodeIdProvider(clusterManager);
    }

    @Bean
    public RedirectsLoopPreventer seraphRedirectsLoopPreventer() {
        return new SeraphRedirectsLoopPreventer();
    }

    @Bean
    public TunnelAuditService tunnelAuditService(I18nResolver i18nResolver) {
        return new DefaultTunnelAuditService(OsgiServices.importOsgiService(AuditService.class), i18nResolver);
    }

    @Bean
    public TunnelProperties tunnelProperties() {
        return new DefaultTunnelProperties();
    }
}

