/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.upgrade;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.tunnel.configuration.dao.TunnelDao;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;

public class UpgradeTask001
implements PluginUpgradeTask {
    private final TunnelDao plainTextTunnelDao;
    private final TunnelDao encryptingTunnelDao;

    public UpgradeTask001(TunnelDao plainTextTunnelDao, TunnelDao encryptingTunnelDao) {
        this.plainTextTunnelDao = plainTextTunnelDao;
        this.encryptingTunnelDao = encryptingTunnelDao;
    }

    public int getBuildNumber() {
        return 1;
    }

    @Nonnull
    public String getShortDescription() {
        return "Encrypting tunnel token";
    }

    public Collection<Message> doUpgrade() throws Exception {
        this.plainTextTunnelDao.getTunnel().ifPresent(this.encryptingTunnelDao::saveTunnel);
        return Collections.emptySet();
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.securetunnel.client.tunnel-client-plugin";
    }
}

