/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.modes.CFBModeCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AESNativeCFB
implements CFBModeCipher {
    private final int bitSize;
    private CFBRefWrapper referenceWrapper;
    private byte[] oldIv;
    private boolean encrypting;

    public AESNativeCFB() {
        this(128);
    }

    public AESNativeCFB(int n) {
        this.bitSize = n;
        switch (n) {
            case 128: {
                break;
            }
            default: {
                throw new IllegalArgumentException("native feedback bit size can only be 128");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            boolean bl2 = this.encrypting;
            this.encrypting = bl;
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (cipherParameters instanceof ParametersWithIV) {
                ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                byArray2 = parametersWithIV.getIV();
                if (byArray2.length > this.getBlockSize() || byArray2.length < 1) {
                    throw new IllegalArgumentException("initialisation vector must be between one and block size length");
                }
                if (byArray2.length < this.getBlockSize()) {
                    byte[] byArray3 = new byte[this.getBlockSize()];
                    System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
                    byArray2 = byArray3;
                }
                this.oldIv = Arrays.clone(byArray2);
                if (parametersWithIV.getParameters() != null) {
                    byArray = Arrays.clone(((KeyParameter)parametersWithIV.getParameters()).getKey());
                }
                if (byArray != null) {
                    bl2 = this.encrypting;
                    byArray = Arrays.clone(byArray);
                } else {
                    byArray = this.referenceWrapper != null ? this.referenceWrapper.getKey() : null;
                }
            } else if (cipherParameters instanceof KeyParameter) {
                byArray = Arrays.clone(((KeyParameter)cipherParameters).getKey());
                byArray2 = this.oldIv;
            }
            if (byArray == null && bl2 != this.encrypting) {
                throw new IllegalArgumentException("cannot change encrypting state without providing key.");
            }
            if (byArray2 == null) {
                throw new IllegalArgumentException("iv is null");
            }
            this.referenceWrapper = new CFBRefWrapper(AESNativeCFB.makeNative(this.encrypting, byArray.length), byArray);
            this.init(this.referenceWrapper.getReference(), byArray, byArray2);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "AES/CFB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte returnByte(byte by) {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            return AESNativeCFB.processByte(this.referenceWrapper.getReference(), by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCFB.processBytes(this.referenceWrapper.getReference(), byArray, n, n2, byArray2, n3);
        }
    }

    @Override
    public int getBlockSize() {
        return this.bitSize / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCFB.processBytes(this.referenceWrapper.getReference(), byArray, n, this.getBlockSize(), byArray2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper == null) {
                return;
            }
            AESNativeCFB.reset(this.referenceWrapper.getReference());
        }
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeCFB.getNativeMultiBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("CFB engine not initialized");
            }
            return this.processBytes(byArray, n, n2 * this.getBlockSize(), byArray2, n3);
        }
    }

    private static native byte processByte(long var0, byte var2);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6) throws DataLengthException;

    static native long makeNative(boolean var0, int var1);

    native void init(long var1, byte[] var3, byte[] var4);

    static native void dispose(long var0);

    static native int getNativeMultiBlockSize();

    private static native void reset(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper != null && this.referenceWrapper.getKey() != null) {
                return "CFB[Native](AES[Native](" + this.referenceWrapper.getKey().length * 8 + "))";
            }
            return "CFB[Native](AES[Native](not initialized))";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class CFBRefWrapper
    extends NativeReference {
        private final byte[] key;

        public CFBRefWrapper(long l, byte[] byArray) {
            super(l, "CFB");
            this.key = byArray;
        }

        public byte[] getKey() {
            return this.key;
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference, this.key);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        private final byte[] key;

        Disposer(long l, byte[] byArray) {
            super(l);
            this.key = byArray;
        }

        @Override
        protected void dispose(long l) {
            Arrays.clear(this.key);
            AESNativeCFB.dispose(l);
        }
    }
}

