/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import javax.security.auth.DestroyFailedException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.engines.AESNativeGCMPacketCipher;
import org.bouncycastle.crypto.engines.AESPacketCipher;
import org.bouncycastle.crypto.modes.AESGCMModePacketCipher;
import org.bouncycastle.crypto.modes.PacketCipherChecks;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class AESGCMPacketCipher
implements AESGCMModePacketCipher {
    private boolean destroyed = false;
    private byte[] lastIV;
    private byte[] lastKey;
    private static final byte[] deadKeyInstance = new byte[0];

    public static AESGCMModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/GCM-PC")) {
            return new AESNativeGCMPacketCipher();
        }
        return new AESGCMPacketCipher();
    }

    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        int n2 = this.checkParameters(cipherParameters);
        if (bl) {
            return PacketCipherChecks.addCheckInputOverflow(n, n2);
        }
        if (n < n2) {
            throw new OutputLengthException("output buffer too short");
        }
        return n - n2;
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        int n4;
        long l;
        byte[] byArray3;
        byte[] byArray4;
        int n5;
        byte[] byArray5;
        byte[] byArray6;
        CipherParameters cipherParameters2;
        PacketCipherChecks.checkBoundsInput(byArray, n, n2, byArray2, n3);
        long[][] lArray = new long[256][2];
        int n6 = n3;
        if (cipherParameters instanceof AEADParameters) {
            cipherParameters2 = (AEADParameters)cipherParameters;
            byArray6 = ((AEADParameters)cipherParameters2).getNonce();
            byArray5 = ((AEADParameters)cipherParameters2).getAssociatedText();
            int n7 = ((AEADParameters)cipherParameters2).getMacSize();
            if (n7 < 32 || n7 > 128 || (n7 & 7) != 0) {
                throw PacketCipherException.from(new IllegalArgumentException("invalid mac size: " + n7));
            }
            n5 = n7 >> 3;
            if (((AEADParameters)cipherParameters2).getKey() != null) {
                PacketCipherChecks.checkKeyLength(((AEADParameters)cipherParameters2).getKey().getKeyLength());
                byArray4 = Arrays.clone(((AEADParameters)cipherParameters2).getKey().getKey());
            } else {
                byArray4 = null;
            }
        } else if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            byArray6 = Arrays.clone(((ParametersWithIV)cipherParameters2).getIV());
            byArray5 = null;
            n5 = 16;
            if (((ParametersWithIV)cipherParameters2).getParameters() != null) {
                PacketCipherChecks.checkKeyLength(((KeyParameter)((ParametersWithIV)cipherParameters2).getParameters()).getKeyLength());
                byArray4 = Arrays.clone(((KeyParameter)((ParametersWithIV)cipherParameters2).getParameters()).getKey());
            } else {
                byArray4 = null;
            }
        } else {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameters passed to GCM"));
        }
        if (byArray6.length < 12) {
            PacketCipherException.from(new IllegalArgumentException("nonce must be at least 12 byte"));
        }
        if (bl && this.lastIV != null && Arrays.areEqual(this.lastIV, byArray6)) {
            if (byArray4 == null) {
                throw PacketCipherException.from(new IllegalArgumentException("cannot reuse nonce for GCM encryption"));
            }
            if (this.lastKey != null && Arrays.areEqual(this.lastKey, byArray4)) {
                throw PacketCipherException.from(new IllegalArgumentException("cannot reuse nonce for GCM encryption"));
            }
        }
        byte[] byArray7 = byArray4 != null ? byArray4 : Arrays.clone(this.lastKey);
        this.lastIV = Arrays.clone(byArray6);
        this.lastKey = Arrays.clone(byArray7);
        int n8 = bl ? n2 : n2 - n5;
        long l2 = n8;
        int n9 = bl ? n2 + n5 : n2 - n5;
        PacketCipherChecks.checkInputAndOutputAEAD(bl, byArray, n, n2, byArray2, n3, n5);
        byte[] byArray8 = AESPacketCipher.createS(true);
        int[][] nArray = AESPacketCipher.generateWorkingKey(true, byArray7);
        byte[] byArray9 = new byte[16];
        AESPacketCipher.processBlock(true, nArray, byArray8, byArray9, 0, byArray9, 0);
        AESGCMPacketCipher.initMultiplier(lArray, byArray9);
        byte[] byArray10 = new byte[16];
        if (byArray6.length == 12) {
            System.arraycopy(byArray6, 0, byArray10, 0, byArray6.length);
            byArray10[byArray10.length - 1] = 1;
        } else {
            AESGCMPacketCipher.gHASH(byArray10, byArray6, byArray6.length, lArray);
            byArray3 = new byte[16];
            Pack.longToBigEndian((long)byArray6.length * 8L, byArray3, 8);
            AESGCMPacketCipher.gHASHBlock(byArray10, byArray3, lArray);
        }
        byArray3 = new byte[16];
        if (byArray5 != null) {
            int n10;
            l = byArray5.length;
            n4 = 0;
            for (n10 = byArray5.length; n10 > byArray3.length; n10 -= byArray3.length) {
                AESGCMPacketCipher.gHASHBlock(byArray3, byArray5, n4, lArray);
                n4 += byArray3.length;
            }
            AESGCMPacketCipher.gHASHPartial(byArray3, byArray5, n4, n10, lArray);
        } else {
            l = 0L;
        }
        byte[] byArray11 = Arrays.clone(byArray10);
        n4 = -2;
        byte[] byArray12 = new byte[16];
        while (n8 > 16) {
            n4 = this.assertBlocksRemaining(n4);
            AESGCMPacketCipher.getNextCtrBlock(byArray11);
            AESPacketCipher.processBlock(true, nArray, byArray8, byArray11, 0, byArray12, 0);
            GCMUtil.xor(byArray12, byArray, n);
            if (bl) {
                AESGCMPacketCipher.gHASHBlock(byArray3, byArray12, lArray);
            } else {
                AESGCMPacketCipher.gHASHBlock(byArray3, byArray, n, lArray);
            }
            System.arraycopy(byArray12, 0, byArray2, n3, 16);
            n8 -= 16;
            n3 += 16;
            n += 16;
        }
        this.assertBlocksRemaining(n4);
        AESGCMPacketCipher.getNextCtrBlock(byArray11);
        AESPacketCipher.processBlock(true, nArray, byArray8, byArray11, 0, byArray12, 0);
        if (bl) {
            GCMUtil.xor(byArray12, 0, byArray, n, n8);
            AESGCMPacketCipher.gHASHPartial(byArray3, byArray12, 0, n8, lArray);
        } else {
            AESGCMPacketCipher.gHASHPartial(byArray3, byArray, n, n8, lArray);
            GCMUtil.xor(byArray12, 0, byArray, n, n8);
        }
        n += n8;
        System.arraycopy(byArray12, 0, byArray2, n3, n8);
        n3 += n8;
        byte[] byArray13 = new byte[16];
        Pack.longToBigEndian(l * 8L, byArray13, 0);
        Pack.longToBigEndian(l2 * 8L, byArray13, 8);
        AESGCMPacketCipher.gHASHBlock(byArray3, byArray13, lArray);
        byte[] byArray14 = new byte[16];
        AESPacketCipher.processBlock(true, nArray, byArray8, byArray10, 0, byArray14, 0);
        GCMUtil.xor(byArray14, byArray3);
        if (bl) {
            System.arraycopy(byArray14, 0, byArray2, n3, n5);
        } else if (!Arrays.constantTimeAreEqual(n5, byArray14, 0, byArray, n)) {
            Arrays.clear(byArray2, n6, (int)l2);
            throw PacketCipherException.from(new InvalidCipherTextException("mac check in GCM failed"));
        }
        Arrays.clear(byArray6);
        Arrays.clear(byArray3);
        Arrays.clear(byArray10);
        Arrays.clear(byArray13);
        Arrays.clear(byArray9);
        Arrays.clear(lArray);
        Arrays.clear(nArray);
        Arrays.clear(byArray7);
        return n9;
    }

    private int assertBlocksRemaining(int n) throws PacketCipherException {
        if (n == 0) {
            throw PacketCipherException.from(new IllegalStateException("Attempt to process too many blocks"));
        }
        return --n;
    }

    private static void getNextCtrBlock(byte[] byArray) {
        int n = 1;
        byArray[15] = (byte)(n += byArray[15] & 0xFF);
        n >>>= 8;
        byArray[14] = (byte)(n += byArray[14] & 0xFF);
        n >>>= 8;
        byArray[13] = (byte)(n += byArray[13] & 0xFF);
        n >>>= 8;
        byArray[12] = (byte)(n += byArray[12] & 0xFF);
    }

    private static void gHASH(byte[] byArray, byte[] byArray2, int n, long[][] lArray) {
        for (int i = 0; i < n; i += 16) {
            int n2 = Math.min(n - i, 16);
            AESGCMPacketCipher.gHASHPartial(byArray, byArray2, i, n2, lArray);
        }
    }

    private static void gHASHBlock(byte[] byArray, byte[] byArray2, long[][] lArray) {
        GCMUtil.xor(byArray, byArray2);
        AESGCMPacketCipher.multiplyH(byArray, lArray);
    }

    private static void gHASHBlock(byte[] byArray, byte[] byArray2, int n, long[][] lArray) {
        GCMUtil.xor(byArray, byArray2, n);
        AESGCMPacketCipher.multiplyH(byArray, lArray);
    }

    private static void gHASHPartial(byte[] byArray, byte[] byArray2, int n, int n2, long[][] lArray) {
        GCMUtil.xor(byArray, byArray2, n, n2);
        AESGCMPacketCipher.multiplyH(byArray, lArray);
    }

    private static void multiplyH(byte[] byArray, long[][] lArray) {
        long[] lArray2 = lArray[byArray[15] & 0xFF];
        long l = lArray2[0];
        long l2 = lArray2[1];
        for (int i = 14; i >= 0; --i) {
            lArray2 = lArray[byArray[i] & 0xFF];
            long l3 = l2 << 56;
            l2 = lArray2[1] ^ (l2 >>> 8 | l << 56);
            l = lArray2[0] ^ l >>> 8 ^ l3 ^ l3 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7;
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }

    protected static void initMultiplier(long[][] lArray, byte[] byArray) {
        GCMUtil.asLongs(byArray, lArray[1]);
        GCMUtil.multiplyP7(lArray[1], lArray[1]);
        for (int i = 2; i < 256; i += 2) {
            GCMUtil.divideP(lArray[i >> 1], lArray[i]);
            GCMUtil.xor(lArray[i], lArray[1], lArray[i + 1]);
        }
    }

    public String toString() {
        return "GCM-PS[Java](AES[Java])";
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.destroyed = true;
        Arrays.clear(this.lastKey);
        Arrays.clear(this.lastIV);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

