/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.v2.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import java.net.URI;
import java.util.Objects;

@ExperimentalApi
public class RestPageRequest
implements PageRequest {
    public static final String START_QPARAM = "start";
    public static final String LIMIT_QPARAM = "limit";
    public static final String CURSOR_QPARAM = "cursor";
    private final int start;
    private final Cursor cursor;
    private final int limit;
    private final URI requestUri;

    public RestPageRequest(URI requestUri, int start, int limit) {
        this(requestUri, start, null, limit);
    }

    public RestPageRequest(URI requestUri, Cursor cursor, int limit) {
        this(requestUri, 0, cursor, limit);
    }

    protected RestPageRequest(URI requestUri, int start, Cursor cursor, int limit) {
        if (start > 0 && cursor != null) {
            throw new BadRequestException("start shouldn't be used together with cursor");
        }
        if (limit < 0 || start < 0) {
            throw new BadRequestException("limit and start must be greater than or equal to 0");
        }
        this.requestUri = requestUri;
        this.start = start;
        this.cursor = cursor;
        this.limit = limit;
    }

    public RestPageRequest(URI requestUri, PageRequest original) {
        this(requestUri, original.getStart(), original.getCursor(), original.getLimit());
    }

    public RestPageRequest copyWithLimits(PageResponse<?> response) {
        PageRequest request = Objects.requireNonNull(response.getPageRequest(), "PageRequest should not be null");
        return new RestPageRequest(this.requestUri, request.getStart(), request.getCursor(), request.getLimit());
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public URI getRequestUri() {
        return this.requestUri;
    }
}

