/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.spacedirectory;

import bucket.core.PaginationSupport;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.ManualTotalPaginationSupport;
import com.atlassian.confluence.plugins.spacedirectory.events.SpaceDirectoryViewEvent;
import com.atlassian.confluence.plugins.spacedirectory.rest.SpaceDirectoryScope;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceLogoManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class ViewSpaceDirectoryAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(ViewSpaceDirectoryAction.class);
    public static final int BLANK_EXPERIENCE_SPACE_THRESHOLD = 4;
    private final SpaceManager spaceManager;
    private int startIndex;
    private static final int DEFAULT_PAGE_SIZE = 24;
    private String teamLabel;
    private List<Space> spaceList;
    private int totalSize = 0;
    private PaginationSupport<Space> paginationSupport;
    private final PredefinedSearchBuilder predefinedSearchBuilder;
    private final SpaceLogoManager spaceLogoManager;
    private final SearchManager searchManager;
    private String selectedSpaceCategory;
    private boolean showBlankExperience;
    private boolean hasCreatePermission;

    public ViewSpaceDirectoryAction(@ComponentImport SpaceManager spaceManager, @ComponentImport SpaceLogoManager spaceLogoManager, @ComponentImport PredefinedSearchBuilder predefinedSearchBuilder, @ComponentImport SearchManager searchManager) {
        this.searchManager = searchManager;
        this.startIndex = 0;
        this.spaceManager = spaceManager;
        this.spaceLogoManager = spaceLogoManager;
        this.predefinedSearchBuilder = predefinedSearchBuilder;
    }

    public PaginationSupport<Space> getPaginationSupport() {
        if (this.paginationSupport == null) {
            this.initSpaces();
            this.paginationSupport = new ManualTotalPaginationSupport(this.spaceList, this.startIndex, this.totalSize, 24);
        }
        return this.paginationSupport;
    }

    private void initSpaces() {
        this.spaceList = new ArrayList<Space>();
        SearchQueryParameters params = new SearchQueryParameters();
        params.setContentTypes(SpaceDirectoryScope.GLOBAL.getContentTypes());
        params.setSort((SearchSort)TitleSort.ASCENDING);
        ISearch search = this.predefinedSearchBuilder.buildSiteSearch(params, this.startIndex, 24);
        try {
            SearchResults searchResults = this.searchManager.search(search);
            this.totalSize = searchResults.getUnfilteredResultsCount();
            for (SearchResult searchResult : searchResults) {
                Space space = this.spaceManager.getSpace(searchResult.getSpaceKey());
                if (space == null) continue;
                this.spaceList.add(space);
            }
        }
        catch (InvalidSearchException e) {
            log.error("Error while searching for spaces", (Throwable)e);
        }
    }

    public String convertToNiceTeamLabel(String teamLabel) {
        return StringUtils.capitalize((String)teamLabel);
    }

    public List<Space> getSpaces() {
        return this.getPaginationSupport().getPage();
    }

    public List<Label> getTeamLabels() {
        return this.labelManager.getTeamLabels();
    }

    public String getTeamLabel() {
        return this.teamLabel;
    }

    public String getLogoDownloadPath(Space space) {
        return this.spaceLogoManager.getLogoDownloadPath(space, (User)AuthenticatedUserThreadLocal.get());
    }

    public int getPageSize() {
        return 24;
    }

    @StrutsParameter
    public void setTeamLabel(String teamLabel) {
        this.teamLabel = teamLabel;
    }

    @StrutsParameter
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    @StrutsParameter
    public void setSelectedSpaceCategory(String selectedSpaceCategory) {
        this.selectedSpaceCategory = selectedSpaceCategory;
    }

    public String getSelectedSpaceCategory() {
        return this.selectedSpaceCategory;
    }

    public boolean isShowBlankExperience() {
        return this.showBlankExperience;
    }

    public boolean isHasCreatePermission() {
        return this.hasCreatePermission;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        this.initSpaces();
        this.paginationSupport = new ManualTotalPaginationSupport(this.spaceList, this.startIndex, this.totalSize, 24);
        this.hasCreatePermission = this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.get(), PermissionManager.TARGET_APPLICATION, Space.class);
        this.showBlankExperience = this.determineShowBlankExperience();
        this.eventPublisher.publish((Object)new SpaceDirectoryViewEvent(this));
        return "success";
    }

    private boolean determineShowBlankExperience() {
        return this.totalSize < 4;
    }
}

