/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.spacedirectory.rest;

import com.atlassian.confluence.core.datetime.DateFormatterFactory;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.plugins.rest.jackson2.entities.DateEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.LabelEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.LabelEntityList;
import com.atlassian.confluence.plugins.rest.jackson2.entities.Link;
import com.atlassian.confluence.plugins.rest.jackson2.manager.RequestContextThreadLocal;
import com.atlassian.confluence.plugins.spacedirectory.rest.SpaceDirectoryEntity;
import com.atlassian.confluence.plugins.spacedirectory.rest.SpaceDirectoryEntityBuilder;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.AddressableSpace;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceLogoManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.userstatus.FavouriteManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultSpaceDirectoryEntityBuilder
implements SpaceDirectoryEntityBuilder {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String ANONYMOUS_USERNAME = "null";
    private final I18NBeanFactory i18nBeanFactory;
    private final GlobalSettingsManager settingsManager;
    private final SpaceManager spaceManager;
    private final FavouriteManager favouriteManager;
    private final SpaceLogoManager spaceLogoManager;
    private final DateFormatterFactory dateFormatterFactory;

    @Autowired
    public DefaultSpaceDirectoryEntityBuilder(@ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport GlobalSettingsManager settingsManager, @ComponentImport FavouriteManager favouriteManager, @ComponentImport SpaceManager spaceManager, @ComponentImport SpaceLogoManager spaceLogoManager, @ComponentImport DateFormatterFactory dateFormatterFactory) {
        this.i18nBeanFactory = i18NBeanFactory;
        this.settingsManager = settingsManager;
        this.favouriteManager = favouriteManager;
        this.spaceManager = spaceManager;
        this.spaceLogoManager = spaceLogoManager;
        this.dateFormatterFactory = dateFormatterFactory;
    }

    @Override
    public SpaceDirectoryEntity build(SearchResult searchResult) {
        Space space = this.spaceManager.getSpace(searchResult.getSpaceKey());
        if (space == null || space.getDescription() == null) {
            return null;
        }
        ConfluenceUser user = RequestContextThreadLocal.get().getUser();
        SpaceDirectoryEntity entity = new SpaceDirectoryEntity();
        entity.setName(space.getName());
        entity.setKey(space.getKey());
        entity.addLink(Link.self((URI)RequestContextThreadLocal.get().getBuiltUri("space", new Object[]{space.getKey()})));
        entity.setCreatedDate(this.convertToDateEntity(space.getCreationDate()));
        entity.setLastModifiedDate(this.convertToDateEntity(space.getLastModificationDate()));
        entity.setWikiLink("[" + space.getKey() + ":]");
        entity.setSummaryPath("/spaces/viewspacesummary.action?key=" + space.getKey());
        try {
            entity.addLink(Link.link((URI)new URI(this.settingsManager.getGlobalSettings().getBaseUrl() + String.valueOf(AddressableSpace.of((Space)space).getDeepLinkUri())), (String)"alternate", (String)"text/html"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        entity.setDescription(GeneralUtil.plain2html((String)space.getDescription().getBodyAsString()));
        if (user != null) {
            entity.setEffectiveUser(user.getName());
        } else {
            entity.setEffectiveUser(ANONYMOUS_USERNAME);
        }
        entity.setFavourite(this.favouriteManager.isUserFavourite(user, space));
        SpaceDescription spaceDescription = space.getDescription();
        LabelEntityList labels = this.convertToLabelEntityList(spaceDescription.getVisibleLabels((User)user));
        entity.setLabels(labels);
        try {
            String logo = this.spaceLogoManager.getLogoUriReference(space, (User)user);
            entity.setLogo(Link.link((URI)new URI(logo), (String)"logo", (String)Thumbnail.MimeType.PNG.toString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return entity;
    }

    private LabelEntityList convertToLabelEntityList(List<Label> labels) {
        LabelEntityList list = new LabelEntityList();
        LabelEntityBuilder builder = new LabelEntityBuilder();
        for (Label label : labels) {
            list.addLabel(builder.build(label));
        }
        return list;
    }

    private DateEntity convertToDateEntity(Date date) {
        if (date == null) {
            return null;
        }
        DateEntity entity = new DateEntity();
        FriendlyDateFormatter friendlyDateFormatter = this.dateFormatterFactory.createFriendlyForUser();
        SimpleDateFormat s = new SimpleDateFormat(DATE_FORMAT);
        Message msg = friendlyDateFormatter.getFormatMessage(date);
        entity.setFriendly(this.i18nBeanFactory.getI18NBean().getText(msg));
        entity.setDate(s.format(date));
        return entity;
    }
}

