/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.spacedirectory.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.LimitedSpace;
import com.atlassian.confluence.api.model.content.LimitedSpaceResponse;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.core.SearchContext;
import com.atlassian.confluence.plugins.rest.jackson2.resources.AbstractResource;
import com.atlassian.confluence.plugins.spacedirectory.rest.SpaceDirectory;
import com.atlassian.confluence.plugins.spacedirectory.rest.SpaceDirectoryEntity;
import com.atlassian.confluence.plugins.spacedirectory.rest.SpaceDirectoryEntityBuilder;
import com.atlassian.confluence.plugins.spacedirectory.rest.SpaceDirectoryScope;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.LowercaseFieldSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@AnonymousSiteAccess
@Produces(value={"application/xml", "application/json"})
public class SpaceDirectoryResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(SpaceDirectoryResource.class);
    private static final int DEFAULT_MAX_PAGE_SIZE = 50;
    private final PredefinedSearchBuilder predefinedSearchBuilder;
    private final SearchManager searchManager;
    private final SpaceService spaceService;
    private final ApplicationProperties applicationProperties;
    private final SpaceDirectoryEntityBuilder builder;

    @Inject
    public SpaceDirectoryResource(@ComponentImport UserAccessor userAccessor, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport SpaceService spaceService, @ComponentImport PredefinedSearchBuilder predefinedSearchBuilder, @ComponentImport SearchManager searchManager, @ComponentImport ApplicationProperties applicationProperties, SpaceDirectoryEntityBuilder builder) {
        super(userAccessor, spacePermissionManager);
        this.predefinedSearchBuilder = predefinedSearchBuilder;
        this.searchManager = searchManager;
        this.spaceService = spaceService;
        this.applicationProperties = applicationProperties;
        this.builder = builder;
    }

    @GET
    @Path(value="/search")
    @AnonymousSiteAccess
    @ScopesAllowed(requiredScope={"READ"})
    public Response doSearch(@QueryParam(value="query") String query, @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="label") Set<String> label, @QueryParam(value="type") String typeStr, @QueryParam(value="status") String status, @DefaultValue(value="false") @QueryParam(value="filterUnauthorizedSpaces") boolean filterUnauthorizedSpaces) {
        SpaceDirectory result = new SpaceDirectory();
        try {
            SearchQueryParameters params = this.buildDefaultParams(query, label, status, typeStr, filterUnauthorizedSpaces);
            params.setSort((SearchSort)TitleSort.ASCENDING);
            ISearch search = this.predefinedSearchBuilder.buildSiteSearch(params, startIndex, Math.min(50, pageSize == null ? 50 : pageSize));
            SearchResults searchResults = this.searchManager.search(search);
            ArrayList<SpaceDirectoryEntity> directoryList = new ArrayList<SpaceDirectoryEntity>();
            for (SearchResult searchResult : searchResults) {
                SpaceDirectoryEntity entity = this.builder.build(searchResult);
                if (entity == null) continue;
                directoryList.add(entity);
            }
            result.setSpaces(directoryList);
            result.setTotalSize(searchResults.getUnfilteredResultsCount());
        }
        catch (IllegalArgumentException e) {
            log.debug("An illegal arg was given for search for spaces.", (Throwable)e);
        }
        catch (InvalidSearchException e) {
            log.debug("An invalid search was given for search for spaces", (Throwable)e);
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/limitedsearch")
    @AnonymousSiteAccess
    @RateLimited
    @ScopesAllowed(requiredScope={"READ_ALL"})
    @LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
    public Response doLimitedSearch(@QueryParam(value="query") String query, @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="label") Set<String> label, @QueryParam(value="type") String typeStr, @QueryParam(value="status") String status, @DefaultValue(value="ascending") @QueryParam(value="sort") String sort, @DefaultValue(value="spaceKey") @QueryParam(value="sortField") String sortField, @DefaultValue(value="false") @QueryParam(value="filterUnauthorizedSpaces") boolean filterUnauthorizedSpaces) {
        LimitedSpaceResponse limitedSpaceResponse;
        SearchSort.Order sortOrder;
        log.debug("Performing a limited space directory search for '{}' with labels {}", (Object)query, label);
        if (pageSize != null && pageSize < 1) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Page size must be greater than 0. Or empty to use the default maximum page size of 50.").build();
        }
        try {
            sortOrder = SearchSort.Order.valueOf((String)sort.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid sort order: '" + sort + "'. Allowed values are: ascending, descending.")).build();
        }
        try {
            SearchQueryParameters params = this.buildDefaultParams(query, label, status, typeStr, filterUnauthorizedSpaces);
            if (sortField.equals("spaceName")) {
                params.setSort(new TitleSort(sortOrder).expand());
            } else if (sortField.equals("spaceKey")) {
                params.setSort((SearchSort)new LowercaseFieldSort(SearchFieldMappings.SPACE_KEY, sortOrder));
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid sort field: '" + sortField + "'. Allowed values are: spaceName, spaceKey.")).build();
            }
            ISearch search = this.predefinedSearchBuilder.buildSiteSearch(params, startIndex, pageSize == null ? 50 : pageSize);
            SearchResults searchResults = this.searchManager.search(search);
            HashSet<String> spaceKeys = new HashSet<String>();
            for (SearchResult searchResult : searchResults) {
                SpaceDirectoryEntity entity = this.builder.build(searchResult);
                if (entity == null) continue;
                spaceKeys.add(entity.getKey());
            }
            SimplePageRequest pageRequest = new SimplePageRequest(0, 50);
            List spaces = this.spaceService.find(new Expansion[0]).withKeys(spaceKeys.toArray(new String[0])).fetchMany((PageRequest)pageRequest).getResults();
            Map keyToSpace = spaces.stream().collect(Collectors.toMap(Space::getKey, Function.identity()));
            ArrayList<LimitedSpace> limitedSpaces = new ArrayList<LimitedSpace>();
            String absoluteDefaultIconUrl = LimitedSpace.createAbsoluteLink((String)"/images/logo/default-space-logo.svg", (String)this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
            for (SearchResult searchResult : searchResults) {
                SpaceDirectoryEntity entity = this.builder.build(searchResult);
                if (entity == null) continue;
                String key = entity.getKey();
                Space space = (Space)keyToSpace.get(key);
                if (space != null) {
                    limitedSpaces.add(new LimitedSpace(Long.valueOf(space.getId()), space.getName().isEmpty() || space.getName() == null ? key : space.getName(), key, absoluteDefaultIconUrl));
                    continue;
                }
                log.warn("Space with key '{}' not found in the space service results.", (Object)key);
            }
            limitedSpaceResponse = new LimitedSpaceResponse(limitedSpaces, limitedSpaces.size(), searchResults.isLastPage());
        }
        catch (InvalidSearchException | IllegalArgumentException e) {
            log.debug("An error was given for limited search for spaces.", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("An error occurred while searching for spaces: " + e.getMessage())).build();
        }
        return Response.ok((Object)limitedSpaceResponse).build();
    }

    private void setSpaceStatusParams(String status, SearchQueryParameters params) {
        if (status == null) {
            params.setIncludeArchivedSpaces(true);
            params.setOnlyArchivedSpaces(false);
        } else if ("archived".equals(status)) {
            params.setOnlyArchivedSpaces(true);
        } else if ("current".equals(status)) {
            params.setIncludeArchivedSpaces(false);
        }
    }

    private SearchQueryParameters buildDefaultParams(String query, Set<String> label, String status, String typeStr, boolean filterUnauthorizedSpaces) {
        this.createRequestContext();
        SearchQueryParameters params = new SearchQueryParameters(query);
        params.setLabels(label);
        params.setExtraFields(Set.of(SearchFieldMappings.SPACE_KEY.getName()));
        this.setSpaceStatusParams(status, params);
        SpaceDirectoryScope scope = SpaceDirectoryScope.toScope(typeStr);
        params.setContentTypes(scope.getContentTypes());
        SearchContext searchContext = SearchContext.getDefaultSearchContext();
        searchContext.setPermissionExempt(!filterUnauthorizedSpaces);
        params.setSearchContext(searchContext);
        return params;
    }
}

