/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TextUtil {
    private static final List<String> SINGLE_TAGS = Arrays.asList("br", "p", "hr");

    private TextUtil() {
    }

    static String trimToEndingChar(String str, int len) {
        boolean inTag = false;
        boolean anyTags = false;
        StringBuilder result = new StringBuilder();
        int goodChars = 0;
        int lastEndingCharPos = -1;
        if (str.length() < len) {
            return str;
        }
        char[] strA = str.toCharArray();
        for (int i = 0; i < strA.length; ++i) {
            if (strA[i] == '<' && !inTag) {
                anyTags = true;
                inTag = true;
            }
            if (strA[i] == '>' && inTag) {
                inTag = false;
            }
            if (!inTag) {
                if (TextUtil.isEndingChar(strA[i])) {
                    lastEndingCharPos = i;
                }
                ++goodChars;
            }
            result.append(strA[i]);
            if (goodChars == len) break;
        }
        if (lastEndingCharPos + 1 != result.length()) {
            if (lastEndingCharPos != -1) {
                result = new StringBuilder(result.substring(0, lastEndingCharPos + 1));
            } else {
                int spacePos = result.toString().lastIndexOf(32);
                if (spacePos != -1) {
                    result = new StringBuilder(result.substring(0, spacePos));
                }
            }
        }
        if (anyTags) {
            return TextUtil.closeTags(result.toString());
        }
        return result.toString();
    }

    private static String closeTags(String str) {
        char[] strA;
        HashMap<String, Integer> openTags = new HashMap<String, Integer>();
        if (str == null) {
            str = "";
        }
        boolean inTag = false;
        boolean inTagName = false;
        boolean inOpenTag = true;
        String tagName = "";
        for (char c : strA = str.toCharArray()) {
            if (!inTag) {
                if (c != '<') continue;
                inTag = true;
                inTagName = true;
                inOpenTag = true;
                tagName = "";
                continue;
            }
            if (tagName.isEmpty() && c == '/') {
                inOpenTag = false;
                continue;
            }
            if (inTagName && (c == ' ' || c == '>' || c == '/')) {
                inTagName = false;
                if (inOpenTag && !SINGLE_TAGS.contains(tagName.toLowerCase())) {
                    openTags.put(tagName, openTags.getOrDefault(tagName, 0) + 1);
                } else {
                    Integer tagCount = (Integer)openTags.get(tagName);
                    if (tagCount != null) {
                        if (tagCount > 1) {
                            openTags.put(tagName, tagCount - 1);
                        } else {
                            openTags.remove(tagName);
                        }
                    }
                }
                if (c != '>') continue;
                inTag = false;
                continue;
            }
            if (inTagName) {
                tagName = tagName + c;
                continue;
            }
            if (c != '>') continue;
            inTag = false;
        }
        Iterator openTagNames = openTags.keySet().iterator();
        StringBuilder closedString = new StringBuilder(str);
        while (openTagNames.hasNext()) {
            String openTagName = (String)openTagNames.next();
            for (int i = 0; i < (Integer)openTags.get(openTagName); ++i) {
                closedString.append("</").append(openTagName).append('>');
            }
        }
        return closedString.toString();
    }

    private static boolean isEndingChar(char c) {
        return c == '.' || c == '!' || c == ',' || c == '?';
    }

    public static String htmlEncode(String s) {
        if (s == null) {
            s = "";
        }
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c < '\u0080') {
                switch (c) {
                    case '\"': {
                        str.append("&quot;");
                        break;
                    }
                    case '\'': {
                        str.append("&#39;");
                        break;
                    }
                    case '&': {
                        str.append("&amp;");
                        break;
                    }
                    case '<': {
                        str.append("&lt;");
                        break;
                    }
                    case '>': {
                        str.append("&gt;");
                        break;
                    }
                    default: {
                        str.append(c);
                        break;
                    }
                }
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }
}

