/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.io.NumberInput;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.deser.JodaDateDeserializerBase;

public class DateTimeDeserializer
extends JodaDateDeserializerBase<ReadableInstant> {
    public DateTimeDeserializer(Class<?> cls, JacksonJodaDateFormat format) {
        super(cls, format);
    }

    public DateTimeDeserializer() {
        super(DateTime.class, FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public static <T extends ReadableInstant> ValueDeserializer<T> forType(Class<T> cls) {
        return new DateTimeDeserializer(cls, FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new DateTimeDeserializer(this._valueClass, format);
    }

    public ReadableInstant deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        switch (p.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p.getLongValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getString());
            }
            case 1: {
                String str = ctxt.extractScalarFromObject(p, (ValueDeserializer)this, this.handledType());
                if (str == null) break;
                return this._fromString(p, ctxt, str);
            }
        }
        return (ReadableInstant)this._handleNotNumberOrString(p, ctxt);
    }

    protected ReadableInstant _fromString(JsonParser p, DeserializationContext ctxt, String value) throws JacksonException {
        if ((value = value.trim()).isEmpty()) {
            return (ReadableInstant)this._fromEmptyString(p, ctxt, value);
        }
        int ix = value.indexOf(91);
        if (ix > 0) {
            DateTimeZone tz;
            int ix2 = value.lastIndexOf(93);
            String tzId = ix2 < ix ? value.substring(ix + 1) : value.substring(ix + 1, ix2);
            try {
                tz = DateTimeZone.forID((String)tzId);
            }
            catch (IllegalArgumentException e) {
                ctxt.reportInputMismatch(this.getValueType(ctxt), "Unknown DateTimeZone id '%s'", new Object[]{tzId});
                tz = null;
            }
            value = value.substring(0, ix);
            DateTime result = this._format.createParser(ctxt).withZone(tz).parseDateTime(value);
            if (this._format.shouldAdjustToContextTimeZone(ctxt)) {
                result = result.withZone(this._format.getTimeZone());
            }
            return result;
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong((String)value));
        }
        return this._format.createParser(ctxt).parseDateTime(value);
    }

    protected DateTime _fromTimestamp(DeserializationContext ctxt, long ts) {
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone());
        return new DateTime(ts, tz);
    }
}

