/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import org.joda.time.DateTimeZone;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.io.NumberInput;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.datatype.joda.deser.JodaDeserializerBase;

public class DateTimeZoneDeserializer
extends JodaDeserializerBase<DateTimeZone> {
    public DateTimeZoneDeserializer() {
        super(DateTimeZone.class);
    }

    public DateTimeZone deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        switch (p.currentTokenId()) {
            case 7: {
                return this._fromOffset(ctxt, p.getIntValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getString());
            }
            case 1: {
                String str = ctxt.extractScalarFromObject(p, (ValueDeserializer)this, this.handledType());
                if (str == null) break;
                return this._fromString(p, ctxt, str);
            }
        }
        return (DateTimeZone)this._handleNotNumberOrString(p, ctxt);
    }

    protected DateTimeZone _fromString(JsonParser p, DeserializationContext ctxt, String value) throws JacksonException {
        if ((value = value.trim()).isEmpty()) {
            return (DateTimeZone)this._fromEmptyString(p, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromOffset(ctxt, NumberInput.parseInt((String)value));
        }
        return DateTimeZone.forID((String)value);
    }

    protected DateTimeZone _fromOffset(DeserializationContext ctxt, int offset) {
        return DateTimeZone.forOffsetHours((int)offset);
    }
}

