/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import java.io.IOException;
import org.joda.time.Duration;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.io.NumberInput;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import tools.jackson.datatype.joda.deser.JodaDeserializerBase;

public class DurationDeserializer
extends JodaDeserializerBase<Duration> {
    protected final JacksonJodaPeriodFormat _format;

    public DurationDeserializer() {
        this(FormatConfig.DEFAULT_PERIOD_FORMAT);
    }

    public DurationDeserializer(JacksonJodaPeriodFormat format) {
        super(Duration.class);
        this._format = format;
    }

    public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        switch (p.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p.getLongValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getString());
            }
            case 1: {
                String str = ctxt.extractScalarFromObject(p, (ValueDeserializer)this, this.handledType());
                if (str == null) break;
                return this._fromString(p, ctxt, str);
            }
        }
        return (Duration)this._handleNotNumberOrString(p, ctxt);
    }

    protected Duration _fromString(JsonParser p, DeserializationContext ctxt, String value) throws JacksonException {
        if ((value = value.trim()).isEmpty()) {
            return (Duration)this._fromEmptyString(p, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong((String)value));
        }
        try {
            return this._format.parsePeriod(ctxt, value).toStandardDuration();
        }
        catch (IOException e) {
            throw this._wrapJodaFailure(ctxt, e);
        }
    }

    protected Duration _fromTimestamp(DeserializationContext ctxt, long ts) {
        return new Duration(ts);
    }
}

