/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormatter;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.io.NumberInput;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.deser.JodaDateDeserializerBase;

public class InstantDeserializer
extends JodaDateDeserializerBase<Instant> {
    public InstantDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public InstantDeserializer(JacksonJodaDateFormat format) {
        super(Instant.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new InstantDeserializer(format);
    }

    public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        switch (p.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p.getLongValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getString());
            }
            case 1: {
                String str = ctxt.extractScalarFromObject(p, (ValueDeserializer)this, this.handledType());
                if (str == null) break;
                return this._fromString(p, ctxt, str);
            }
        }
        return (Instant)this._handleNotNumberOrString(p, ctxt);
    }

    protected Instant _fromString(JsonParser p, DeserializationContext ctxt, String value) throws JacksonException {
        if ((value = value.trim()).isEmpty()) {
            return (Instant)this._fromEmptyString(p, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong((String)value));
        }
        return Instant.parse((String)value, (DateTimeFormatter)this._format.createParser(ctxt));
    }

    protected Instant _fromTimestamp(DeserializationContext ctxt, long ts) {
        return new Instant(ts);
    }
}

