/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.deser.JodaDateDeserializerBase;

public class IntervalDeserializer
extends JodaDateDeserializerBase<Interval> {
    public IntervalDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public IntervalDeserializer(JacksonJodaDateFormat format) {
        super(Interval.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new IntervalDeserializer(format);
    }

    public Interval deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        String str;
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getString());
        }
        if (p.isExpectedStartObjectToken() && (str = ctxt.extractScalarFromObject(p, (ValueDeserializer)this, this.handledType())) != null) {
            return this._fromString(p, ctxt, str);
        }
        return (Interval)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p.currentToken(), p, "expected JSON String", new Object[0]);
    }

    protected Interval _fromString(JsonParser p, DeserializationContext ctxt, String value) throws JacksonException {
        DateTimeZone tz;
        Interval result;
        boolean hasSlash;
        if ((value = value.trim()).isEmpty()) {
            return (Interval)this._fromEmptyString(p, ctxt, value);
        }
        int index = value.indexOf(47, 1);
        boolean bl = hasSlash = index > 0;
        if (!hasSlash) {
            index = value.indexOf(45, 1);
        }
        if (index < 0) {
            throw ctxt.weirdStringException(value, this.handledType(), "no slash or hyphen found to separate start, end");
        }
        String str = value.substring(0, index);
        try {
            if (hasSlash) {
                result = Interval.parseWithOffset((String)value);
            } else {
                long start = Long.parseLong(str);
                str = value.substring(index + 1);
                long end = Long.parseLong(str);
                result = new Interval(start, end);
            }
        }
        catch (NumberFormatException e) {
            return (Interval)ctxt.handleWeirdStringValue(this.handledType(), str, "Failed to parse number from '%s' (full source String '%s')", new Object[]{str, value});
        }
        DateTimeZone contextTimezone = this._format.shouldAdjustToContextTimeZone(ctxt) ? DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone()) : null;
        DateTimeZone dateTimeZone = tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : contextTimezone;
        if (tz != null && !tz.equals((Object)result.getStart().getZone())) {
            result = new Interval(result.getStartMillis(), result.getEndMillis(), tz);
        }
        return result;
    }
}

