/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import java.io.IOException;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.io.NumberInput;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.deser.std.StdScalarDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.util.ClassUtil;

abstract class JodaDeserializerBase<T>
extends StdScalarDeserializer<T> {
    protected JodaDeserializerBase(Class<?> cls) {
        super(cls);
    }

    protected JodaDeserializerBase(JodaDeserializerBase<?> src) {
        super(src);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        return typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }

    public LogicalType logicalType() {
        return LogicalType.DateTime;
    }

    protected boolean _isValidTimestampString(String str) {
        return this._isIntNumber(str) && NumberInput.inLongRange((String)str, (str.charAt(0) == '-' ? 1 : 0) != 0);
    }

    protected T _fromEmptyString(JsonParser p, DeserializationContext ctxt, String str) throws JacksonException {
        CoercionAction act = this._checkFromStringCoercion(ctxt, str);
        switch (act) {
            case AsEmpty: {
                return (T)this.getEmptyValue(ctxt);
            }
        }
        return null;
    }

    public T _handleNotNumberOrString(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        JavaType type = this.getValueType(ctxt);
        JsonToken t = p.currentToken();
        return (T)ctxt.handleUnexpectedToken(type, t, p, String.format("Cannot deserialize value of type %s from %s (token `JsonToken.%s`): expected Number or String", ClassUtil.getTypeDescription((JavaType)type), JsonToken.valueDescFor((JsonToken)t), p.currentToken()), new Object[0]);
    }

    public T _handleNotString(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        JavaType type = this.getValueType(ctxt);
        JsonToken t = p.currentToken();
        return (T)ctxt.handleUnexpectedToken(type, t, p, String.format("Cannot deserialize value of type %s from %s (token `JsonToken.%s`): expected String", ClassUtil.getTypeDescription((JavaType)type), JsonToken.valueDescFor((JsonToken)t), p.currentToken()), new Object[0]);
    }

    protected JacksonException _wrapJodaFailure(DeserializationContext ctxt, IOException e) {
        return this._wrapIOFailure(ctxt, e);
    }
}

