/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.io.NumberInput;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.deser.JodaDateDeserializerBase;

public class LocalDateTimeDeserializer
extends JodaDateDeserializerBase<LocalDateTime> {
    public LocalDateTimeDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_PARSER);
    }

    public LocalDateTimeDeserializer(JacksonJodaDateFormat format) {
        super(LocalDateTime.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new LocalDateTimeDeserializer(format);
    }

    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        switch (p.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p.getLongValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getString());
            }
            case 1: {
                String str = ctxt.extractScalarFromObject(p, (ValueDeserializer)this, this.handledType());
                if (str == null) break;
                return this._fromString(p, ctxt, str);
            }
        }
        if (p.isExpectedStartArrayToken()) {
            return this._fromArray(p, ctxt);
        }
        return (LocalDateTime)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p.currentToken(), p, "expected String, Number or JSON Array", new Object[0]);
    }

    protected LocalDateTime _fromString(JsonParser p, DeserializationContext ctxt, String value) throws JacksonException {
        if ((value = value.trim()).isEmpty()) {
            return (LocalDateTime)this._fromEmptyString(p, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong((String)value));
        }
        return this._format.createParser(ctxt).parseLocalDateTime(value);
    }

    protected LocalDateTime _fromArray(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        JsonToken t = p.nextToken();
        LocalDateTime dt = null;
        if (t.isNumeric()) {
            int year = p.getIntValue();
            t = p.nextToken();
            if (t.isNumeric()) {
                int month = p.getIntValue();
                t = p.nextToken();
                if (t.isNumeric()) {
                    int day = p.getIntValue();
                    t = p.nextToken();
                    if (t.isNumeric()) {
                        int hour = p.getIntValue();
                        t = p.nextToken();
                        if (t.isNumeric()) {
                            int minute = p.getIntValue();
                            t = p.nextToken();
                            if (t.isNumeric()) {
                                int second = p.getIntValue();
                                t = p.nextToken();
                                int millisecond = 0;
                                if (t.isNumeric()) {
                                    millisecond = p.getIntValue();
                                    t = p.nextToken();
                                }
                                dt = new LocalDateTime(year, month, day, hour, minute, second, millisecond);
                            }
                        }
                    }
                }
            }
        }
        if (t == JsonToken.END_ARRAY) {
            return dt;
        }
        throw ctxt.wrongTokenException(p, this.getValueType(ctxt), JsonToken.END_ARRAY, "after LocalDateTime ints");
    }

    protected LocalDateTime _fromTimestamp(DeserializationContext ctxt, long ts) {
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone());
        return new LocalDateTime(ts, tz);
    }
}

