/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import org.joda.time.MonthDay;
import org.joda.time.format.DateTimeFormatter;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.deser.JodaDateDeserializerBase;

public class MonthDayDeserializer
extends JodaDateDeserializerBase<MonthDay> {
    public MonthDayDeserializer() {
        this(FormatConfig.DEFAULT_MONTH_DAY_FORMAT);
    }

    public MonthDayDeserializer(JacksonJodaDateFormat format) {
        super(MonthDay.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new MonthDayDeserializer(format);
    }

    public MonthDay deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        String str;
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getString());
        }
        if (p.isExpectedStartObjectToken() && (str = ctxt.extractScalarFromObject(p, (ValueDeserializer)this, this.handledType())) != null) {
            return this._fromString(p, ctxt, str);
        }
        return (MonthDay)this._handleNotString(p, ctxt);
    }

    protected MonthDay _fromString(JsonParser p, DeserializationContext ctxt, String value) throws JacksonException {
        if ((value = value.trim()).isEmpty()) {
            return (MonthDay)this._fromEmptyString(p, ctxt, value);
        }
        return MonthDay.parse((String)value, (DateTimeFormatter)this._format.createParser(ctxt));
    }
}

