/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import java.io.IOException;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import tools.jackson.datatype.joda.deser.JodaDeserializerBase;

public class PeriodDeserializer
extends JodaDeserializerBase<ReadablePeriod> {
    private final JacksonJodaPeriodFormat _format = FormatConfig.DEFAULT_PERIOD_FORMAT;
    private final boolean _requireFullPeriod;

    public PeriodDeserializer() {
        this(true);
    }

    public PeriodDeserializer(boolean fullPeriod) {
        super(fullPeriod ? Period.class : ReadablePeriod.class);
        this._requireFullPeriod = fullPeriod;
    }

    public ReadablePeriod deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_STRING) {
            return this._fromString(p, ctxt, p.getString());
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Period(p.getLongValue());
        }
        if (t != JsonToken.START_OBJECT && t != JsonToken.PROPERTY_NAME) {
            return (ReadablePeriod)ctxt.handleUnexpectedToken(this.getValueType(ctxt), t, p, "expected JSON Number, String or Object", new Object[0]);
        }
        return this._fromObject(p, ctxt);
    }

    protected ReadablePeriod _fromString(JsonParser p, DeserializationContext ctxt, String value) throws JacksonException {
        if ((value = value.trim()).isEmpty()) {
            return (ReadablePeriod)this._fromEmptyString(p, ctxt, value);
        }
        try {
            return this._format.parsePeriod(ctxt, value);
        }
        catch (IOException e) {
            throw this._wrapJodaFailure(ctxt, e);
        }
    }

    protected ReadablePeriod _fromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Seconds rp;
        JsonNode treeNode = (JsonNode)p.readValueAsTree();
        String periodType = treeNode.path("fieldType").path("name").asString();
        String periodName = treeNode.path("periodType").path("name").asString();
        int periodValue = treeNode.path(periodType).asInt();
        if (periodName.equals("Seconds")) {
            rp = Seconds.seconds((int)periodValue);
        } else if (periodName.equals("Minutes")) {
            rp = Minutes.minutes((int)periodValue);
        } else if (periodName.equals("Hours")) {
            rp = Hours.hours((int)periodValue);
        } else if (periodName.equals("Days")) {
            rp = Days.days((int)periodValue);
        } else if (periodName.equals("Weeks")) {
            rp = Weeks.weeks((int)periodValue);
        } else if (periodName.equals("Months")) {
            rp = Months.months((int)periodValue);
        } else if (periodName.equals("Years")) {
            rp = Years.years((int)periodValue);
        } else {
            JavaType type = this.getValueType(ctxt);
            ctxt.reportInputMismatch(type, "Don't know how to deserialize %s using periodName '%s'", new Object[]{ClassUtil.getTypeDescription((JavaType)type), periodName});
            return null;
        }
        if (this._requireFullPeriod && !(rp instanceof Period)) {
            rp = rp.toPeriod();
        }
        return rp;
    }
}

