/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.deser;

import org.joda.time.YearMonth;
import org.joda.time.format.DateTimeFormatter;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.deser.JodaDateDeserializerBase;

public class YearMonthDeserializer
extends JodaDateDeserializerBase<YearMonth> {
    public YearMonthDeserializer() {
        this(FormatConfig.DEFAULT_YEAR_MONTH_FORMAT);
    }

    public YearMonthDeserializer(JacksonJodaDateFormat format) {
        super(YearMonth.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new YearMonthDeserializer(format);
    }

    public YearMonth deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        String str;
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getString());
        }
        if (p.isExpectedStartObjectToken() && (str = ctxt.extractScalarFromObject(p, (ValueDeserializer)this, this.handledType())) != null) {
            return this._fromString(p, ctxt, str);
        }
        return (YearMonth)this._handleNotString(p, ctxt);
    }

    protected YearMonth _fromString(JsonParser p, DeserializationContext ctxt, String value) throws JacksonException {
        if ((value = value.trim()).isEmpty()) {
            return (YearMonth)this._fromEmptyString(p, ctxt, value);
        }
        return YearMonth.parse((String)value, (DateTimeFormatter)this._format.createParser(ctxt));
    }
}

