/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.ser;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.ser.JodaDateSerializerBase;

public class DateTimeSerializer
extends JodaDateSerializerBase<DateTime> {
    public DateTimeSerializer() {
        this(FormatConfig.DEFAULT_DATETIME_PRINTER, 0);
    }

    public DateTimeSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public DateTimeSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(DateTime.class, format, DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS, 2, shapeOverride);
    }

    public DateTimeSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new DateTimeSerializer(formatter, shapeOverride);
    }

    @Override
    public boolean isEmpty(SerializationContext ctxt, DateTime value) {
        return value.getMillis() == 0L;
    }

    public void serialize(DateTime value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        boolean numeric;
        boolean bl = numeric = this._serializationShape(ctxt) != 1;
        if (!this.writeWithZoneId(ctxt)) {
            if (numeric) {
                gen.writeNumber(value.getMillis());
            } else {
                gen.writeString(this._format.createFormatterWithTimeZoneOverride(ctxt, value.getZone()).print((ReadableInstant)value));
            }
        } else {
            if (numeric) {
                gen.writeNumber(value.getMillis());
                return;
            }
            StringBuilder sb = new StringBuilder(40).append(this._format.createFormatter(ctxt).withOffsetParsed().print((ReadableInstant)value));
            sb = sb.append('[').append(value.getZone()).append(']');
            gen.writeString(sb.toString());
        }
    }
}

