/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.ser;

import org.joda.time.Duration;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.ser.JodaDateSerializerBase;

public class DurationSerializer
extends JodaDateSerializerBase<Duration> {
    public DurationSerializer() {
        this(FormatConfig.DEFAULT_DATEONLY_FORMAT, 0);
    }

    public DurationSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public DurationSerializer(JacksonJodaDateFormat formatter, int shapeOverride) {
        super(Duration.class, formatter, DateTimeFeature.WRITE_DURATIONS_AS_TIMESTAMPS, 2, shapeOverride);
    }

    public DurationSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new DurationSerializer(formatter, shapeOverride);
    }

    @Override
    public boolean isEmpty(SerializationContext ctxt, Duration value) {
        return value.getMillis() == 0L;
    }

    public void serialize(Duration value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this._serializationShape(ctxt) == 1) {
            g.writeString(value.toString());
        } else {
            g.writeNumber(value.getMillis());
        }
    }
}

