/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.ser;

import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.ser.JodaDateSerializerBase;

public class InstantSerializer
extends JodaDateSerializerBase<Instant> {
    public InstantSerializer() {
        this(FormatConfig.DEFAULT_DATETIME_PRINTER, 0);
    }

    public InstantSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public InstantSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(Instant.class, format, DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS, 2, shapeOverride);
    }

    public InstantSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new InstantSerializer(formatter, shapeOverride);
    }

    @Override
    public boolean isEmpty(SerializationContext ctxt, Instant value) {
        return value.getMillis() == 0L;
    }

    public void serialize(Instant value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        if (this._serializationShape(ctxt) == 1) {
            gen.writeString(this._format.createFormatter(ctxt).print((ReadableInstant)value));
        } else {
            gen.writeNumber(value.getMillis());
        }
    }
}

