/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.ser;

import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.ser.JodaDateSerializerBase;

public class IntervalSerializer
extends JodaDateSerializerBase<Interval> {
    public IntervalSerializer() {
        this(FormatConfig.DEFAULT_DATETIME_PRINTER, 0);
    }

    public IntervalSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public IntervalSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(Interval.class, format, DateTimeFeature.WRITE_DURATIONS_AS_TIMESTAMPS, 2, shapeOverride);
    }

    public IntervalSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new IntervalSerializer(formatter, shapeOverride);
    }

    @Override
    public boolean isEmpty(SerializationContext ctxt, Interval value) {
        return value.getStartMillis() == value.getEndMillis();
    }

    public void serialize(Interval interval, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        String repr;
        if (this._serializationShape(ctxt) == 1) {
            DateTimeFormatter f = this._format.createFormatter(ctxt);
            repr = f.print((ReadableInstant)interval.getStart()) + "/" + f.print((ReadableInstant)interval.getEnd());
        } else {
            repr = interval.getStartMillis() + "-" + interval.getEndMillis();
        }
        gen.writeString(repr);
    }
}

