/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.ser.JodaSerializerBase;

public abstract class JodaDateSerializerBase<T>
extends JodaSerializerBase<T> {
    protected static final int FORMAT_STRING = 1;
    protected static final int FORMAT_TIMESTAMP = 2;
    protected static final int FORMAT_ARRAY = 3;
    protected final JacksonJodaDateFormat _format;
    protected final DateTimeFeature _featureForNumeric;
    protected final int _defaultNumericShape;
    protected final int _shapeOverride;

    protected JodaDateSerializerBase(Class<T> type, JacksonJodaDateFormat format, DateTimeFeature numericFeature, int defaultNumericShape, int shapeOverride) {
        super(type);
        this._format = format;
        this._featureForNumeric = numericFeature;
        this._defaultNumericShape = defaultNumericShape;
        this._shapeOverride = shapeOverride;
    }

    public abstract JodaDateSerializerBase<T> withFormat(JacksonJodaDateFormat var1, int var2);

    public boolean isEmpty(SerializationContext ctxt, T value) {
        return value == null;
    }

    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonFormat.Value ann = this.findFormatOverrides(ctxt, property, this.handledType());
        if (ann != null) {
            int shapeOverride;
            Boolean useTimestamp;
            JsonFormat.Shape shape = ann.getShape();
            if (shape.isNumeric()) {
                useTimestamp = Boolean.TRUE;
                shapeOverride = 2;
            } else if (shape == JsonFormat.Shape.STRING) {
                useTimestamp = Boolean.FALSE;
                shapeOverride = 1;
            } else if (shape == JsonFormat.Shape.ARRAY) {
                useTimestamp = Boolean.TRUE;
                shapeOverride = 3;
            } else {
                useTimestamp = null;
                shapeOverride = this._shapeOverride;
            }
            JacksonJodaDateFormat format = this._format;
            if (useTimestamp != null) {
                format = format.withUseTimestamp(useTimestamp);
            }
            if ((format = format.with(ann)) != this._format || shapeOverride != this._shapeOverride) {
                return this.withFormat(format, shapeOverride);
            }
        }
        return this;
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        switch (this._serializationShape(visitor.getContext())) {
            case 2: {
                JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
                if (v2 == null) break;
                v2.numberType(JsonParser.NumberType.LONG);
                v2.format(JsonValueFormat.UTC_MILLISEC);
                break;
            }
            case 3: {
                JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
                if (v2 == null) break;
                v2.itemsFormat(JsonFormatTypes.INTEGER);
                break;
            }
            default: {
                JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
                if (v2 == null) break;
                v2.format(JsonValueFormat.DATE_TIME);
            }
        }
    }

    protected boolean writeWithZoneId(SerializationContext ctxt) {
        return this._format.shouldWriteWithZoneId(ctxt);
    }

    protected int _serializationShape(SerializationContext ctxt) {
        int shape = this._shapeOverride;
        if (shape == 0) {
            shape = this._format.useTimestamp(ctxt, this._featureForNumeric) ? this._defaultNumericShape : 1;
        }
        return shape;
    }
}

