/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.ser;

import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.ser.JodaDateSerializerBase;

public class LocalDateSerializer
extends JodaDateSerializerBase<LocalDate> {
    public LocalDateSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATEONLY_FORMAT, 0);
    }

    public LocalDateSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public LocalDateSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(LocalDate.class, format, DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS, 3, shapeOverride);
    }

    public LocalDateSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new LocalDateSerializer(formatter, shapeOverride);
    }

    public void serialize(LocalDate value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this._serializationShape(ctxt) == 1) {
            g.writeString(this._format.createFormatter(ctxt).print((ReadablePartial)value));
            return;
        }
        g.writeStartArray();
        g.writeNumber(value.year().get());
        g.writeNumber(value.monthOfYear().get());
        g.writeNumber(value.dayOfMonth().get());
        g.writeEndArray();
    }
}

