/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.ser;

import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.ser.JodaDateSerializerBase;

public class LocalDateTimeSerializer
extends JodaDateSerializerBase<LocalDateTime> {
    public LocalDateTimeSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_PRINTER, 0);
    }

    public LocalDateTimeSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public LocalDateTimeSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(LocalDateTime.class, format, DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS, 3, shapeOverride);
    }

    public LocalDateTimeSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new LocalDateTimeSerializer(formatter, shapeOverride);
    }

    public void serialize(LocalDateTime value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        switch (this._serializationShape(ctxt)) {
            case 1: {
                gen.writeString(this._format.createFormatter(ctxt).print((ReadablePartial)value));
                break;
            }
            case 2: {
                DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone());
                gen.writeNumber(value.toDateTime(tz).getMillis());
                break;
            }
            case 3: {
                gen.writeStartArray();
                gen.writeNumber(value.year().get());
                gen.writeNumber(value.monthOfYear().get());
                gen.writeNumber(value.dayOfMonth().get());
                gen.writeNumber(value.hourOfDay().get());
                gen.writeNumber(value.minuteOfHour().get());
                gen.writeNumber(value.secondOfMinute().get());
                gen.writeNumber(value.millisOfSecond().get());
                gen.writeEndArray();
            }
        }
    }
}

