/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.ser;

import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import tools.jackson.datatype.joda.ser.JodaDateSerializerBase;

public class LocalTimeSerializer
extends JodaDateSerializerBase<LocalTime> {
    public LocalTimeSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_TIMEONLY_PRINTER, 0);
    }

    public LocalTimeSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public LocalTimeSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(LocalTime.class, format, DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS, 3, shapeOverride);
    }

    public LocalTimeSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new LocalTimeSerializer(formatter, shapeOverride);
    }

    public void serialize(LocalTime value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this._serializationShape(ctxt) == 1) {
            g.writeString(this._format.createFormatter(ctxt).print((ReadablePartial)value));
            return;
        }
        g.writeStartArray();
        g.writeNumber(value.hourOfDay().get());
        g.writeNumber(value.minuteOfHour().get());
        g.writeNumber(value.secondOfMinute().get());
        g.writeNumber(value.millisOfSecond().get());
        g.writeEndArray();
    }
}

