/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.datatype.joda.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.joda.time.ReadablePeriod;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.datatype.joda.cfg.FormatConfig;
import tools.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import tools.jackson.datatype.joda.ser.JodaSerializerBase;

public class PeriodSerializer
extends JodaSerializerBase<ReadablePeriod> {
    protected final JacksonJodaPeriodFormat _format;

    public PeriodSerializer() {
        this(FormatConfig.DEFAULT_PERIOD_FORMAT);
    }

    protected PeriodSerializer(JacksonJodaPeriodFormat format) {
        super(ReadablePeriod.class);
        this._format = format;
    }

    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonFormat.Value ann;
        if (property != null && (ann = this.findFormatOverrides(ctxt, property, this.handledType())) != null) {
            JacksonJodaPeriodFormat format = this._format;
            Boolean useTimestamp = ann.getShape().isNumeric() ? Boolean.TRUE : (ann.getShape() == JsonFormat.Shape.STRING ? Boolean.FALSE : (ann.getShape() == JsonFormat.Shape.ARRAY ? Boolean.TRUE : null));
            if (useTimestamp != null) {
                format = format.withUseTimestamp(useTimestamp);
            }
            format = format.withFormat(ann.getPattern());
            if ((format = format.withLocale(ann.getLocale())) != this._format) {
                return new PeriodSerializer(format);
            }
        }
        return this;
    }

    public void serialize(ReadablePeriod value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        g.writeString(this._format.createFormatter(ctxt).print(value));
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
        if (v2 != null) {
            // empty if block
        }
    }
}

