/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks;

import com.atlassian.webhooks.WebhookCredentials;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.util.BuilderUtil;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.validator.constraints.URL;

public abstract class AbstractWebhookRequest {
    private final boolean active;
    private final Map<String, String> configuration;
    private final WebhookCredentials credentials;
    private final List<WebhookEvent> events;
    private final String name;
    private final WebhookScope scope;
    private final boolean sslVerificationRequired;
    private final String url;

    AbstractWebhookRequest(AbstractBuilder<?> builder) {
        this.active = builder.active;
        this.configuration = Collections.unmodifiableMap(new HashMap<String, String>(builder.configuration));
        this.credentials = builder.credentials;
        this.events = Collections.unmodifiableList(new ArrayList<WebhookEvent>(builder.events));
        this.name = builder.name == null ? builder.url : builder.name;
        this.scope = builder.scope;
        this.sslVerificationRequired = builder.sslVerificationRequired;
        this.url = builder.url;
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public Optional<WebhookCredentials> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    @Nonnull
    @NotEmpty(message="{webhooks.event.required}")
    @Valid
    public @NotEmpty(message="{webhooks.event.required}") @Valid List<WebhookEvent> getEvents() {
        return this.events;
    }

    @NotBlank(message="{webhooks.field.name.required}")
    @Size(max=255)
    public @NotBlank(message="{webhooks.field.name.required}") @Size(max=255) String getName() {
        return this.name;
    }

    @NotNull(message="{webhooks.field.required}")
    public @NotNull(message="{webhooks.field.required}") WebhookScope getScope() {
        return this.scope;
    }

    @NotNull(message="{webhooks.field.url.required}")
    @URL
    public @NotNull(message="{webhooks.field.url.required}") @URL String getUrl() {
        return this.url;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isSslVerificationRequired() {
        return this.sslVerificationRequired;
    }

    static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private final Map<String, String> configuration = new HashMap<String, String>();
        private final List<WebhookEvent> events = new ArrayList<WebhookEvent>();
        private boolean active = true;
        private WebhookCredentials credentials;
        private String name;
        private WebhookScope scope;
        private boolean sslVerificationRequired = true;
        private String url;

        AbstractBuilder() {
        }

        @Nonnull
        public B active(boolean value) {
            this.active = value;
            return this.self();
        }

        @Nonnull
        public B configuration(@Nullable Map<String, String> value) {
            if (value != null) {
                value.forEach(this::configuration);
            }
            return this.self();
        }

        @Nonnull
        public B configuration(@Nullable String key, @Nullable String value) {
            if (key != null) {
                if (value == null) {
                    this.configuration.remove(key);
                } else {
                    this.configuration.put(key, value);
                }
            }
            return this.self();
        }

        @Nonnull
        public B credentials(@Nullable WebhookCredentials value) {
            this.credentials = value;
            return this.self();
        }

        @Nonnull
        public B event(@Nullable Iterable<WebhookEvent> values) {
            BuilderUtil.addIf(Objects::nonNull, this.events, values);
            return this.self();
        }

        @Nonnull
        public B event(@Nullable WebhookEvent value, WebhookEvent ... values) {
            BuilderUtil.addIf(Objects::nonNull, this.events, value, values);
            return this.self();
        }

        @Nonnull
        public B name(@Nullable String value) {
            this.name = value;
            return this.self();
        }

        @Nonnull
        public B scope(@Nullable WebhookScope value) {
            this.scope = value;
            return this.self();
        }

        @Nonnull
        public B sslVerificationRequired(boolean value) {
            this.sslVerificationRequired = value;
            return this.self();
        }

        @Nonnull
        public B url(@Nullable String value) {
            this.url = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

