/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.incrementalsync.model;

import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncModel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@RestEnrichable
public class IncrementalSyncPageResponse<T extends IncrementalSyncModel>
implements PageResponse<T> {
    private final PageRequest pageRequest;
    private final List<T> results;
    private final boolean hasMore;
    private final Cursor nextCursor;
    private final boolean incrementalSynchronisationAvailable;

    private IncrementalSyncPageResponse(PageRequest pageRequest, List<T> results, boolean hasMore, Cursor cursor, boolean incrementalSynchronisationAvailable) {
        this.pageRequest = pageRequest;
        this.results = Collections.unmodifiableList(results);
        this.hasMore = hasMore;
        this.nextCursor = cursor;
        this.incrementalSynchronisationAvailable = incrementalSynchronisationAvailable;
    }

    public boolean isIncrementalSynchronisationAvailable() {
        return this.incrementalSynchronisationAvailable;
    }

    public List<T> getResults() {
        return this.results;
    }

    public int size() {
        return this.results.size();
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public Cursor getNextCursor() {
        return this.nextCursor;
    }

    public Iterator<T> iterator() {
        return this.results.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncrementalSyncPageResponse that = (IncrementalSyncPageResponse)o;
        return this.hasMore == that.hasMore && this.incrementalSynchronisationAvailable == that.incrementalSynchronisationAvailable && Objects.equals(this.pageRequest, that.pageRequest) && Objects.equals(this.results, that.results) && Objects.equals(this.nextCursor, that.nextCursor);
    }

    public int hashCode() {
        return Objects.hash(this.pageRequest, this.results, this.hasMore, this.nextCursor, this.incrementalSynchronisationAvailable);
    }

    public static <T extends IncrementalSyncModel> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends IncrementalSyncModel> {
        private PageRequest pageRequest;
        private List<T> results;
        private boolean hasMore;
        private Cursor nextCursor;
        private boolean incrementalSynchronisationAvailable;

        public IncrementalSyncPageResponse<T> build() {
            return new IncrementalSyncPageResponse<T>(this.pageRequest, this.results, this.hasMore, this.nextCursor, this.incrementalSynchronisationAvailable);
        }

        public Builder<T> from(IncrementalSyncPageResponse<T> response) {
            this.pageRequest = response.getPageRequest();
            this.results = response.getResults();
            this.hasMore = response.hasMore();
            this.nextCursor = response.getNextCursor();
            this.incrementalSynchronisationAvailable = response.isIncrementalSynchronisationAvailable();
            return this;
        }

        public Builder<T> setPageRequest(PageRequest pageRequest) {
            this.pageRequest = pageRequest;
            return this;
        }

        public Builder<T> setResults(List<T> results) {
            this.results = results;
            return this;
        }

        public Builder<T> setNextCursor(Cursor nextCursor) {
            this.nextCursor = nextCursor;
            return this;
        }

        public Builder<T> setIncrementalSynchronisationAvailable(boolean incrementalSynchronisationAvailable) {
            this.incrementalSynchronisationAvailable = incrementalSynchronisationAvailable;
            return this;
        }

        public Builder<T> setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            return this;
        }
    }
}

