/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.store.algorithm.serialization;

import com.atlassian.secrets.api.SecretStoreException;
import com.atlassian.secrets.store.algorithm.serialization.SafeObjectInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class SerializationFile {
    private static final Log log = LogFactory.getLog(SerializationFile.class);
    public static final Set<String> DESERIALIZATION_ALLOWED_CLASSES = new HashSet<String>(Arrays.asList(SealedObject.class.getCanonicalName(), SecretKeySpec.class.getCanonicalName(), SecretKey.class.getCanonicalName(), "[B"));
    private final String notEmptyFilePath;

    public SerializationFile(String notEmptyFilePath) {
        this.notEmptyFilePath = notEmptyFilePath;
    }

    public <T> void createFileAndSave(T objectToSave) {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.notEmptyFilePath));){
            objectOutputStream.writeObject(objectToSave);
            log.debug((Object)String.format("Saved file: %s", this.notEmptyFilePath));
        }
        catch (IOException e) {
            log.error((Object)String.format("Couldn't save or create file needed for encryption/decryption. Tried to save object: %s using file path: %s", objectToSave, this.notEmptyFilePath), (Throwable)e);
            throw new SecretStoreException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T read(Class<T> clazz) {
        try (SafeObjectInputStream objectIn = new SafeObjectInputStream(new FileInputStream(this.notEmptyFilePath), DESERIALIZATION_ALLOWED_CLASSES);){
            Object o = objectIn.readObject();
            if (!o.getClass().getCanonicalName().equals(clazz.getCanonicalName())) {
                throw new ClassCastException("Expected: " + String.valueOf(clazz) + ", got: " + String.valueOf(o.getClass()));
            }
            Object object = o;
            return (T)object;
        }
        catch (IOException e) {
            log.error((Object)String.format("Couldn't read file needed for encryption/decryption. Tried to read file under: %s", this.notEmptyFilePath), (Throwable)e);
            throw new SecretStoreException((Throwable)e);
        }
        catch (ClassCastException e) {
            log.error((Object)String.format("Couldn't cast object found under: %s Make sure you are passing correct file path.", this.notEmptyFilePath), (Throwable)e);
            throw new SecretStoreException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)String.format("Couldn't find class for object found under: %s Make sure you are passing correct file path.", this.notEmptyFilePath), (Throwable)e);
            throw new SecretStoreException((Throwable)e);
        }
    }
}

