/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.tomcat.utils;

import com.atlassian.secrets.api.SecretStoreException;
import com.atlassian.secrets.tomcat.utils.DecryptTool;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;

public class DecryptionUtils {
    private static final Log log = LogFactory.getLog(DecryptionUtils.class);

    public static void initSecrets(Optional<String> secretKey, Optional<String> encryptionKey, Consumer<String> setter) {
        secretKey.ifPresentOrElse(secret -> {
            DecryptTool decryptTool = DecryptionUtils.getDecryptTool(encryptionKey);
            decryptTool.decrypt(() -> secret, setter, "secret");
            log.debug((Object)"All passwords have been set");
        }, () -> log.debug((Object)"No passwords to set"));
    }

    public static void initPasswords(SSLHostConfig[] sslHostConfigs, Optional<String> encryptionKey) {
        if (sslHostConfigs.length == 0) {
            log.debug((Object)"No passwords to set");
            return;
        }
        DecryptTool decryptTool = DecryptionUtils.getDecryptTool(encryptionKey);
        for (SSLHostConfig sslHostConfig : sslHostConfigs) {
            for (SSLHostConfigCertificate certificate : sslHostConfig.getCertificates()) {
                decryptTool.decrypt(() -> ((SSLHostConfigCertificate)certificate).getCertificateKeystorePassword(), arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeystorePassword(arg_0), "CertificateKeystorePassword");
                decryptTool.decrypt(() -> ((SSLHostConfigCertificate)certificate).getCertificateKeyPassword(), arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeyPassword(arg_0), "CertificateKeyPassword");
            }
            decryptTool.decrypt(() -> ((SSLHostConfig)sslHostConfig).getTruststorePassword(), arg_0 -> ((SSLHostConfig)sslHostConfig).setTruststorePassword(arg_0), "TruststorePassword");
        }
        log.debug((Object)"All passwords have been set");
    }

    private static DecryptTool getDecryptTool(Optional<String> encryptionKey) {
        String encryptionKeyFile = encryptionKey.orElseThrow(() -> new SecretStoreException("Cannot decrypt passwords since the encryption key is missing"));
        return new DecryptTool(encryptionKeyFile);
    }
}

