/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.placeholder;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.content.render.image.ImageRenderUtils;
import com.atlassian.confluence.languages.LocaleParser;
import com.atlassian.confluence.tinymceplugin.placeholder.AbstractPlaceholderServlet;
import com.atlassian.confluence.tinymceplugin.placeholder.PlaceholderImageFactory;
import com.atlassian.confluence.tinymceplugin.placeholder.StyledString;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

@AnonymousSiteAccess
public class UnknownMacroPlaceholderServlet
extends AbstractPlaceholderServlet {
    private static final Color UNKNOWN_GADGET_PLACEHOLDER_BACKGROUND = Color.decode("0xF5CD47");
    private static final Color PLACEHOLDER_ERROR_BACKGROUND = Color.decode("0xB3B9C4");
    private static final Color HEADER_ERROR_FOREGROUND = Color.decode("0x1D2125");
    private final PlaceholderImageFactory placeholderImageFactory;
    private final I18NBeanFactory i18NBeanFactory;

    public UnknownMacroPlaceholderServlet(PlaceholderImageFactory placeholderImageFactory, I18NBeanFactory i18NBeanFactory) {
        this.placeholderImageFactory = placeholderImageFactory;
        this.i18NBeanFactory = i18NBeanFactory;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String macroName = req.getParameter("name");
        if (macroName == null) {
            resp.sendError(400, "Request missing macro name");
            return;
        }
        Locale locale = LocaleParser.toLocale((String)req.getParameter("locale"));
        if (locale == null) {
            resp.sendError(400, "Request missing locale");
            return;
        }
        String text = "gadget".equalsIgnoreCase(macroName) ? this.i18NBeanFactory.getI18NBean(locale).getText("xhtml.unknown.macro.gadget") : this.i18NBeanFactory.getI18NBean(locale).getText("xhtml.unknown.macro", (Object[])new String[]{macroName});
        String iconLink = "gadget".equalsIgnoreCase(macroName) ? "/images/icons/macrobrowser/unknown-gadget-macro-placeholder.png" : "/images/icons/macrobrowser/macro-placeholder-default.png";
        Color placeholderErrorBackground = "gadget".equalsIgnoreCase(macroName) ? UNKNOWN_GADGET_PLACEHOLDER_BACKGROUND : PLACEHOLDER_ERROR_BACKGROUND;
        try (InputStream iconStream = this.getServletContext().getResourceAsStream(iconLink);){
            BufferedImage placeholderImage = this.placeholderImageFactory.getPlaceholderImage(new StyledString(text, HEADER_ERROR_FOREGROUND), iconStream, placeholderErrorBackground);
            ImageRenderUtils.writePngToStream((BufferedImage)placeholderImage, (HttpServletResponse)resp);
        }
    }
}

