/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.model.links.DefaultLink;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifier;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.xhtml.api.EditorFormatService;
import com.atlassian.confluence.xhtml.api.Link;
import com.atlassian.confluence.xhtml.api.LinkBody;
import com.atlassian.confluence.xhtml.api.PlainTextLinkBody;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.renderer.RenderContext;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/createlink")
@AnonymousSiteAccess
public class CreateLinkResource {
    private static final Logger log = LoggerFactory.getLogger(CreateLinkResource.class);
    private final EditorFormatService editorFormatService;

    @Inject
    public CreateLinkResource(EditorFormatService editorFormatService) {
        this.editorFormatService = editorFormatService;
    }

    @GET
    @Path(value="/placeholder")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response generatePlaceHolder(@QueryParam(value="pageTitle") String pageTitle, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="alias") String alias) {
        String linkHtml;
        PlainTextLinkBody plainLinkBody = null;
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            plainLinkBody = new PlainTextLinkBody(alias);
        }
        PageResourceIdentifier resourceIdentifier = new PageResourceIdentifier(spaceKey, pageTitle);
        try {
            PageContext pageContext = new PageContext();
            pageContext.setOutputType(ConversionContextOutputType.DISPLAY.value());
            DefaultConversionContext context = new DefaultConversionContext((RenderContext)pageContext);
            linkHtml = this.editorFormatService.convertLinkToEdit((Link)DefaultLink.builder().withDestinationResourceIdentifier((ResourceIdentifier)resourceIdentifier).withBody((LinkBody)plainLinkBody).build(), (ConversionContext)context);
        }
        catch (XhtmlException e) {
            log.error("Error occurred rendering resource", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)linkHtml).build();
    }
}

