/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.relations.CollaboratorRelationDescriptor;
import com.atlassian.confluence.api.model.relations.Relatable;
import com.atlassian.confluence.api.model.relations.RelationDescriptor;
import com.atlassian.confluence.api.model.relations.RelationInstance;
import com.atlassian.confluence.api.service.relations.RelationService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.editor.EditorConverter;
import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.core.datetime.RequestTimeThreadLocal;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.core.service.NotValidException;
import com.atlassian.confluence.event.events.analytics.SharedDraftUpdatedEvent;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.relations.touch.TouchRelationSupport;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.tinymceplugin.rest.DraftChangeResult;
import com.atlassian.confluence.tinymceplugin.rest.entities.DraftData;
import com.atlassian.confluence.tinymceplugin.rest.entities.DraftMessage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.diffs.MergeResult;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.renderer.RenderContext;
import com.atlassian.user.User;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/drafts")
public class DraftsResource {
    private static final Logger log = LoggerFactory.getLogger(DraftsResource.class);
    private static final long DRAFTS_LOCK_TIME_MS = Long.getLong("atlassian.confluence.drafts.shared.lock.time.ms", 0L);
    private static final long DRAFTS_LOCK_LIVE_TIME_SEC = Long.getLong("atlassian.confluence.drafts.shared.cache.ttl.sec", 600L);
    private final UserAccessor userAccessor;
    private final DraftService draftService;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final PermissionManager permissionManager;
    private final DraftManager draftManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final PageManager pageManager;
    private final DraftsTransitionHelper draftsTransitionHelper;
    private final EditorConverter editConverter;
    private final EventPublisher eventPublisher;
    private final RelationService relationService;
    private final TouchRelationSupport touchRelationSupport;
    private final LoadingCache<Long, ReentrantLock> draftsUpdateLock = CacheBuilder.newBuilder().expireAfterAccess(DRAFTS_LOCK_LIVE_TIME_SEC, TimeUnit.SECONDS).build(CacheLoader.from(ReentrantLock::new));

    @Inject
    public DraftsResource(UserAccessor userAccessor, DraftService draftService, FormatSettingsManager formatSettingsManager, LocaleManager localeManager, PermissionManager permissionManager, DraftManager draftManager, I18NBeanFactory i18NBeanFactory, PageManager pageManager, DraftsTransitionHelper draftsTransitionHelper, EditorConverter editConverter, EventPublisher eventPublisher, RelationService relationService, TouchRelationSupport touchRelationSupport) {
        this.userAccessor = userAccessor;
        this.draftService = draftService;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.permissionManager = permissionManager;
        this.draftManager = draftManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.pageManager = pageManager;
        this.draftsTransitionHelper = draftsTransitionHelper;
        this.editConverter = editConverter;
        this.eventPublisher = eventPublisher;
        this.relationService = relationService;
        this.touchRelationSupport = touchRelationSupport;
    }

    @GET
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @Deprecated
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDrafts(@QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) {
        try {
            List drafts = this.draftService.findDrafts(limit, offset);
            ArrayList<DraftData> draftDatum = new ArrayList<DraftData>();
            for (Draft draft : drafts) {
                draftDatum.add(DraftData.create(draft));
            }
            return Response.ok(draftDatum).build();
        }
        catch (NotAuthorizedException ex) {
            return Response.status((int)403).build();
        }
        catch (NotValidException ex) {
            if (ex.getCause() != null) {
                log.warn(ex.getMessage(), ex.getCause());
            }
            HashMap<String, Integer> obj = new HashMap<String, Integer>();
            obj.put("limit", limit);
            obj.put("offset", offset);
            return Response.status((int)422).entity(obj).build();
        }
    }

    @GET
    @Path(value="/message")
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDraftMessage(@QueryParam(value="existingDraftId") long existingDraftId, @QueryParam(value="pageId") long pageId, @QueryParam(value="type") String type, @QueryParam(value="spaceKey") String spaceKey) {
        Draft draft = existingDraftId != 0L ? this.draftManager.getDraft(existingDraftId) : this.draftManager.findDraft(Long.valueOf(pageId), AuthenticatedUserThreadLocal.get(), type, spaceKey);
        if (draft != null) {
            boolean conflictFound = false;
            boolean mergeRequired = false;
            if (this.draftManager.isMergeRequired(draft)) {
                MergeResult mergeResult = this.draftManager.mergeContent(draft);
                conflictFound = mergeResult.hasConflicts();
                mergeRequired = !conflictFound;
            }
            DraftData draftData = DraftData.create(draft);
            draftData.setDate(this.formatFriendlyDate(draft.getLastModificationDate()));
            return Response.ok((Object)new DraftMessage(draftData, draft.isNewPage(), conflictFound, mergeRequired)).build();
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @AnonymousSiteAccess
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response save(DraftData draftData, @DefaultValue(value="false") @QueryParam(value="ignoreRelations") boolean ignoreRelations) {
        String saveTime = this.getEventDate();
        try {
            Long draftId = draftData.getDraftId();
            Long pageId = draftData.getPageId();
            Long contentId = pageId != null && pageId != 0L ? pageId : draftId;
            ContentEntityObject existingDraft = this.draftsTransitionHelper.getDraft(contentId.longValue());
            Optional<ConfluenceUser> confluenceUser = Optional.ofNullable(AuthenticatedUserThreadLocal.get());
            if (existingDraft != null && !this.permissionManager.hasPermissionNoExemptions((ConfluenceUser)confluenceUser.orElse(null), Permission.EDIT, (Object)existingDraft)) {
                return this.getNotAuthorizedResponse(draftData, saveTime);
            }
            if (this.draftsTransitionHelper.isSharedDraftsFeatureEnabled(draftData.getSpaceKey())) {
                if (existingDraft == null) {
                    return Response.status((int)400).entity((Object)new DraftChangeResult(draftData.getDraftId(), draftData.getPageId(), saveTime, "Legacy drafts deprecated")).build();
                }
                draftId = existingDraft.getId();
                Supplier<Void> supplier = () -> {
                    try {
                        existingDraft.setTitle(draftData.getTitle());
                        existingDraft.setBodyAsString(this.editConverter.convert(draftData.getContent(), (ConversionContext)new DefaultConversionContext((RenderContext)new PageContext(existingDraft))));
                        if (!"dummy-sync-rev".equals(draftData.getSyncRev())) {
                            existingDraft.setSynchronyRevision(draftData.getSyncRev());
                        }
                        this.pageManager.saveContentEntity(existingDraft, DefaultSaveContext.DRAFT);
                        this.eventPublisher.publish((Object)new SharedDraftUpdatedEvent());
                    }
                    catch (XhtmlException ex) {
                        throw new NotValidException("The supplied editor content could not be converted to storage format.", (Throwable)ex);
                    }
                    return null;
                };
                Lock lock = (Lock)this.draftsUpdateLock.get((Object)contentId);
                if (lock.tryLock(DRAFTS_LOCK_TIME_MS, TimeUnit.MILLISECONDS)) {
                    try {
                        supplier.get();
                    }
                    finally {
                        lock.unlock();
                    }
                } else {
                    log.debug("Lock {} for draft {} is held by another thread", (Object)contentId, (Object)draftId);
                    return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)new DraftChangeResult(draftData.getDraftId(), draftData.getPageId(), saveTime)).build();
                }
                if (!ignoreRelations) {
                    confluenceUser.ifPresent(user -> this.updateRelations(contentId, existingDraft, (ConfluenceUser)user));
                }
            } else {
                draftId = this.draftService.saveDraftFromEditor(draftData.getDraftId(), draftData.getParentPageId(), draftData.getTitle(), DraftService.DraftType.getByRepresentation((String)draftData.getType()), draftData.getContent(), draftData.getPageId(), draftData.getSpaceKey(), draftData.getPageVersion()).getId();
            }
            return Response.ok((Object)new DraftChangeResult(draftId, draftData.getPageId(), saveTime)).build();
        }
        catch (NotAuthorizedException ex) {
            return this.getNotAuthorizedResponse(draftData, saveTime);
        }
        catch (NotValidException ex) {
            if (ex.getCause() != null) {
                log.warn(ex.getMessage(), ex.getCause());
            }
            DraftChangeResult result = new DraftChangeResult(draftData.getDraftId(), draftData.getPageId(), saveTime, ex.getMessage());
            return Response.status((int)422).entity((Object)result).build();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Error acquiring the lock: {}", (Object)e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new DraftChangeResult(draftData.getDraftId(), draftData.getPageId(), saveTime)).build();
        }
    }

    void updateRelations(Long contentId, ContentEntityObject existingDraft, ConfluenceUser authenticatedUser) {
        KnownUser currentUser = KnownUser.builder().userKey(authenticatedUser.getKey()).username(authenticatedUser.getName()).displayName(authenticatedUser.getFullName()).build();
        Content draftContent = Content.builder().id(ContentId.deserialise((String)contentId.toString())).type(ContentType.valueOf((String)existingDraft.getType())).status(ContentStatus.DRAFT).build();
        this.touchRelationSupport.handleTouchRelations(draftContent);
        this.relationService.create(RelationInstance.builder((Relatable)currentUser, (RelationDescriptor)CollaboratorRelationDescriptor.COLLABORATOR, (Relatable)draftContent).build());
    }

    @DELETE
    @Path(value="/discard")
    @AnonymousSiteAccess
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response discard(DraftData draftData) {
        String saveTime = this.getEventDate();
        try {
            Long removedDraftId = this.draftService.removeDraft(draftData.getPageId().longValue(), draftData.getDraftId().longValue());
            if (removedDraftId != null) {
                return Response.ok((Object)new DraftChangeResult(removedDraftId, draftData.getPageId(), saveTime)).build();
            }
            return Response.status((int)404).entity((Object)new DraftChangeResult(draftData.getDraftId(), draftData.getPageId(), saveTime)).build();
        }
        catch (NotAuthorizedException ex) {
            return this.getNotAuthorizedResponse(draftData, saveTime);
        }
        catch (NotValidException ex) {
            if (ex.getCause() != null) {
                log.warn(ex.getMessage(), ex.getCause());
            }
            DraftChangeResult result = new DraftChangeResult(draftData.getDraftId(), draftData.getPageId(), saveTime, ex.getMessage());
            return Response.status((int)422).entity((Object)result).build();
        }
    }

    Response getNotAuthorizedResponse(DraftData draftData, String saveTime) {
        return Response.status((int)403).entity((Object)new DraftChangeResult(draftData.getDraftId(), draftData.getPageId(), saveTime)).build();
    }

    private String getEventDate() {
        return this.getDateFormatter().formatTime(new Date());
    }

    private DateFormatter getDateFormatter() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return new DateFormatter(this.userAccessor.getUserPreferences(user).getTimeZone(), this.formatSettingsManager, this.localeManager);
    }

    private String formatFriendlyDate(Date date) {
        Message message = this.getFriendlyDateFormatter().getFormatMessage(date);
        return this.getText(message.getKey(), message.getArguments());
    }

    private FriendlyDateFormatter getFriendlyDateFormatter() {
        return new FriendlyDateFormatter(RequestTimeThreadLocal.getTimeOrNow(), this.getDateFormatter());
    }

    private String getText(String key, Object ... args) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Locale locale = this.localeManager.getLocale((User)user);
        return this.i18NBeanFactory.getI18NBean(locale).getText(key, args);
    }
}

