/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.migration.UrlResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.DefaultEmbeddedImage;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.NamedResourceIdentifier;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.tinymceplugin.rest.entities.EmbeddedImagePlaceholderRequest;
import com.atlassian.confluence.xhtml.api.EditorFormatService;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.renderer.RenderContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/embed")
@AnonymousSiteAccess
public class EmbeddedImage {
    private final EditorFormatService editorFormatService;
    private final ContentEntityManager contentEntityManager;

    @Inject
    public EmbeddedImage(EditorFormatService editorFormatService, @Named(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.editorFormatService = editorFormatService;
        this.contentEntityManager = contentEntityManager;
    }

    @POST
    @Path(value="/placeholder/image")
    @Consumes(value={"application/json"})
    @Produces(value={"text/html"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response generatePlaceHolder(EmbeddedImagePlaceholderRequest request) {
        DefaultConversionContext conversionContext;
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(request.getContentId().longValue());
        if (contentEntityObject == null) {
            PageContext renderContext = new PageContext();
            conversionContext = new DefaultConversionContext((RenderContext)renderContext);
        } else {
            conversionContext = new DefaultConversionContext((RenderContext)new PageContext(contentEntityObject));
        }
        DefaultEmbeddedImage embeddedImage = StringUtils.isNotBlank((CharSequence)request.getUrl()) ? new DefaultEmbeddedImage((NamedResourceIdentifier)new UrlResourceIdentifier(request.getUrl())) : new DefaultEmbeddedImage((NamedResourceIdentifier)new AttachmentResourceIdentifier(request.getFilename()));
        if (StringUtils.isNotBlank((CharSequence)request.getAlignment()) && !"none".equals(request.getAlignment())) {
            embeddedImage.setAlignment(request.getAlignment());
        }
        embeddedImage.setBorder(request.isBorder());
        embeddedImage.setThumbnail(request.isThumbnail());
        try {
            return Response.ok((Object)this.editorFormatService.convertEmbeddedImageToEdit((com.atlassian.confluence.xhtml.api.EmbeddedImage)embeddedImage, (ConversionContext)conversionContext)).build();
        }
        catch (XhtmlException e) {
            return Response.serverError().build();
        }
    }
}

