/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.model.links.DefaultLink;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentContainerResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.BlogPostResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.CannotResolveResourceIdentifierException;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.DraftResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.IdAndTypeResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.SpaceResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.UserResourceIdentifier;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.xhtml.api.EditorFormatService;
import com.atlassian.confluence.xhtml.api.Link;
import com.atlassian.confluence.xhtml.api.LinkBody;
import com.atlassian.confluence.xhtml.api.PlainTextLinkBody;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.user.UserKey;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/link")
@AnonymousSiteAccess
public class LinkResource {
    private static final Logger log = LoggerFactory.getLogger(LinkResource.class);
    private final EditorFormatService editorFormatService;
    private final ResourceIdentifierResolver<IdAndTypeResourceIdentifier, Object> idresourceIdentifierResolver;
    private final PermissionManager permissionManager;

    @Inject
    public LinkResource(EditorFormatService editorFormatService, @Named(value="idAndTypeResourceIdentifierResolver") ResourceIdentifierResolver<IdAndTypeResourceIdentifier, Object> resourceIdentifierResolver, PermissionManager permissionManager) {
        this.editorFormatService = editorFormatService;
        this.idresourceIdentifierResolver = resourceIdentifierResolver;
        this.permissionManager = permissionManager;
    }

    @GET
    @Path(value="/placeholder")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response generatePlaceHolder(@QueryParam(value="resourceId") String resourceId, @QueryParam(value="resourceType") String resourceType, @QueryParam(value="alias") String alias) {
        String linkHtml;
        block15: {
            Object resource;
            ContentTypeEnum contentType;
            PlainTextLinkBody plainLinkBody = null;
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                plainLinkBody = new PlainTextLinkBody(alias);
            }
            if ("user".equals(resourceType)) {
                resourceType = "userinfo";
            }
            if ((contentType = ContentTypeEnum.getByRepresentation((String)resourceType)) == null) {
                log.debug("Unsupported resource type: {}", (Object)resourceType.replaceAll("[\r\n]", ""));
                return Response.serverError().build();
            }
            try {
                resource = this.idresourceIdentifierResolver.resolve((ResourceIdentifier)new IdAndTypeResourceIdentifier(Long.parseLong(resourceId), contentType), null);
            }
            catch (CannotResolveResourceIdentifierException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            try {
                PageContext pageContext = new PageContext();
                pageContext.setOutputType(ConversionContextOutputType.DISPLAY.value());
                DefaultConversionContext context = new DefaultConversionContext((RenderContext)pageContext);
                if (resource instanceof Attachment) {
                    Attachment attachment = (Attachment)resource;
                    if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)attachment.getSpace())) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                    }
                    if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)attachment)) {
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                    }
                    AttachmentContainerResourceIdentifier containerResourceIdentifier = (AttachmentContainerResourceIdentifier)this.getResourceIdentifier(attachment.getContainer());
                    AttachmentResourceIdentifier resourceIdentifier = new AttachmentResourceIdentifier(containerResourceIdentifier, attachment.getFileName());
                    linkHtml = this.editorFormatService.convertLinkToEdit((Link)DefaultLink.builder().withDestinationResourceIdentifier((ResourceIdentifier)resourceIdentifier).withBody((LinkBody)plainLinkBody).build(), (ConversionContext)context);
                    break block15;
                }
                if (resource instanceof ContentEntityObject) {
                    ContentEntityObject contentEntityObject = (ContentEntityObject)resource;
                    if (contentEntityObject instanceof Spaced && !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)((Spaced)contentEntityObject).getSpace())) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                    }
                    if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)contentEntityObject)) {
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                    }
                    linkHtml = this.editorFormatService.convertLinkToEdit((Link)DefaultLink.builder().withDestinationResourceIdentifier(this.getResourceIdentifier(contentEntityObject)).withBody((LinkBody)plainLinkBody).build(), (ConversionContext)context);
                    break block15;
                }
                if (resource instanceof Space) {
                    Space space = (Space)resource;
                    if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)space)) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                    }
                    linkHtml = this.editorFormatService.convertLinkToEdit((Link)DefaultLink.builder().withDestinationResourceIdentifier((ResourceIdentifier)new SpaceResourceIdentifier(space.getKey())).withBody((LinkBody)plainLinkBody).build(), (ConversionContext)context);
                    break block15;
                }
                log.error("Unsupported resource: {}", resource);
                return Response.serverError().build();
            }
            catch (XhtmlException e) {
                log.error("Error occurred rendering resource", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        return Response.ok((Object)linkHtml).build();
    }

    private ResourceIdentifier getResourceIdentifier(ContentEntityObject content) {
        PageResourceIdentifier result = null;
        if (content instanceof Page) {
            result = new PageResourceIdentifier(((Page)content).getSpaceKey(), content.getTitle());
        } else if (content instanceof BlogPost) {
            BlogPost blogPost = (BlogPost)content;
            Calendar postingDay = Calendar.getInstance();
            postingDay.setTime(blogPost.getPostingDate());
            result = new BlogPostResourceIdentifier(blogPost.getSpaceKey(), blogPost.getTitle(), postingDay);
        } else if (content instanceof Draft) {
            result = new DraftResourceIdentifier(content.getId());
        } else if (content instanceof PersonalInformation) {
            ConfluenceUser user = ((PersonalInformation)content).getUser();
            result = UserResourceIdentifier.create((UserKey)user.getKey());
        }
        return result;
    }
}

