/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.MacroInstance;
import com.atlassian.confluence.api.model.content.MacroParameterInstance;
import com.atlassian.confluence.api.service.content.ContentMacroService;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.HtmlToXmlConverter;
import com.atlassian.confluence.content.render.xhtml.StorageFormatCleaner;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.PlainTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.RichTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.editor.macro.InvalidMacroParameterException;
import com.atlassian.confluence.content.render.xhtml.editor.macro.MacroParameterTypeParser;
import com.atlassian.confluence.content.render.xhtml.storage.macro.StorageMacroBodyParser;
import com.atlassian.confluence.content.render.xhtml.transformers.FragmentTransformer;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.browser.MacroMetadataManager;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.macro.xhtml.MacroManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.tinymceplugin.rest.entities.Macro;
import com.atlassian.confluence.tinymceplugin.rest.entities.MacroRenderByIdRequest;
import com.atlassian.confluence.tinymceplugin.rest.entities.MacroRenderRequest;
import com.atlassian.confluence.tinymceplugin.rest.entities.PreviewMacroRequest;
import com.atlassian.confluence.tinymceplugin.rest.entities.UnmarshalMacroRequest;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.confluence.xhtml.api.EditorFormatService;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.velocity.htmlsafe.HtmlFragment;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.atlassian.util.concurrent.Timeout;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/macro")
@AnonymousSiteAccess
public class MacroResource {
    private static final Logger log = LoggerFactory.getLogger(MacroResource.class);
    private static final long MACRO_PLACEHOLDER_TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    private static final String MACRO_PLACEHOLDER_TIMEOUT = "confluence.macro.placeholder.timeoutMillis";
    private static final long MACRO_DEFINITION_TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    private static final String MACRO_DEFINITION_TIMEOUT = "confluence.macro.definition.timeoutMillis";
    private static final long MACRO_PREVIEW_TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private static final String MACRO_PREVIEW_TIMEOUT = "confluence.macro.preview.timeoutMillis";
    private static final String NEWLINE_CHARACTER = "\n";
    private static final String NEWLINE_CHARACTER_ENTITY = "&#10;";
    private final XhtmlContent xhtmlContent;
    private final EditorFormatService editorFormatService;
    private final ContentEntityManager contentEntityManager;
    private final HtmlToXmlConverter htmlToXmlConverter;
    private final HttpContext httpContext;
    private final TransactionTemplate transactionTemplate;
    private final MacroManager macroManager;
    private final I18nResolver i18nResolver;
    private final PermissionManager permissionManager;
    private final SpacePermissionManager spacePermissionManager;
    private final MacroParameterTypeParser macroParameterTypeParser;
    private final XmlEventReaderFactory xmlEventReaderFactory;
    private final FragmentTransformer defaultFragmentTransformer;
    private final StorageMacroBodyParser storageMacroBodyParser;
    private final MacroMetadataManager macroMetadataManager;
    private final StorageFormatCleaner storageFormatCleaner;
    private final VelocityHelperService velocityHelperService;
    private final ContentMacroService contentMacroService;
    private final InternalHostApplication internalHostApplication;

    @Inject
    public MacroResource(XhtmlContent xhtmlContent, EditorFormatService editorFormatService, @Named(value="contentEntityManager") ContentEntityManager contentEntityManager, @Named(value="htmlToXmlConverter") HtmlToXmlConverter htmlToXmlConverter, @Named(value="httpContext") HttpContext httpContext, @Named(value="xhtmlMacroManager") MacroManager macroManager, I18nResolver i18nResolver, TransactionTemplate transactionTemplate, PermissionManager permissionManager, @Named(value="spacePermissionManager") SpacePermissionManager spacePermissionManager, MacroParameterTypeParser macroParameterTypeParser, XmlEventReaderFactory xmlEventReaderFactory, FragmentTransformer defaultFragmentTransformer, StorageMacroBodyParser storageMacroBodyParser, MacroMetadataManager macroMetadataManager, StorageFormatCleaner storageFormatCleaner, VelocityHelperService velocityHelperService, @ComponentImport ContentMacroService contentMacroService, @ComponentImport InternalHostApplication internalHostApplication) {
        this.xhtmlContent = xhtmlContent;
        this.editorFormatService = editorFormatService;
        this.contentEntityManager = contentEntityManager;
        this.htmlToXmlConverter = htmlToXmlConverter;
        this.httpContext = httpContext;
        this.macroManager = macroManager;
        this.i18nResolver = i18nResolver;
        this.transactionTemplate = transactionTemplate;
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.macroParameterTypeParser = macroParameterTypeParser;
        this.xmlEventReaderFactory = xmlEventReaderFactory;
        this.defaultFragmentTransformer = defaultFragmentTransformer;
        this.storageMacroBodyParser = storageMacroBodyParser;
        this.macroMetadataManager = macroMetadataManager;
        this.storageFormatCleaner = storageFormatCleaner;
        this.velocityHelperService = velocityHelperService;
        this.contentMacroService = contentMacroService;
        this.internalHostApplication = internalHostApplication;
    }

    @POST
    @Path(value="/placeholder")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response generatePlaceHolder(MacroRenderRequest renderRequest) {
        log.debug("Macro placeholder request for {} received", (Object)renderRequest.getMacro().getName());
        try {
            this.checkUsePermission(AuthenticatedUserThreadLocal.get());
            Long contentId = renderRequest.getContentId();
            Macro macro = renderRequest.getMacro();
            String entity = this.convertMacroToEditorFormat(contentId, macro);
            log.debug("Macro placeholder render complete");
            return Response.ok((Object)entity).build();
        }
        catch (XhtmlException e) {
            throw new RuntimeException(e);
        }
        catch (PermissionException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @POST
    @Path(value="/placeholder/storedmacro")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response generatePlaceHolderForStoredMacro(MacroRenderByIdRequest renderByIdRequest) {
        log.debug("Macro copy placeholder request for {} received", (Object)renderByIdRequest.getContentId());
        if (renderByIdRequest.getContentId() == null) {
            throw new IllegalArgumentException("Content Id cannot be null");
        }
        if (renderByIdRequest.getMacroId() == null) {
            throw new IllegalArgumentException("Macro Id cannot be null");
        }
        if (renderByIdRequest.getHostId() == null) {
            throw new IllegalArgumentException("Host Id Id cannot be null");
        }
        try {
            this.checkUsePermission(AuthenticatedUserThreadLocal.get());
            Long contentId = renderByIdRequest.getContentId().asLong();
            int versionId = renderByIdRequest.getVersionId();
            if (!renderByIdRequest.getHostId().equals((Object)this.internalHostApplication.getId())) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            MacroInstance macroInstance = (MacroInstance)this.contentMacroService.findInContent(renderByIdRequest.getContentId(), new Expansion[0]).withMacroId(renderByIdRequest.getMacroId()).withContentVersion(renderByIdRequest.getVersionId()).fetch().orElseThrow(() -> new NotFoundException("No macro found on content id : " + String.valueOf(renderByIdRequest.getContentId()) + " with version: " + renderByIdRequest.getVersionId() + " and macroId: " + renderByIdRequest.getMacroId()));
            Macro macro = new Macro();
            macro.setName(macroInstance.getName());
            macro.setSchemaVersion(versionId);
            macro.setParams(macroInstance.getParameters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MacroParameterInstance)e.getValue()).getValue())));
            macro.setBody(macroInstance.getBody());
            String entity = this.convertMacroToEditorFormat(contentId, macro);
            log.debug("Macro copy placeholder render complete");
            return Response.ok((Object)entity).build();
        }
        catch (XhtmlException e2) {
            throw new RuntimeException(e2);
        }
        catch (PermissionException e3) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private String convertMacroToEditorFormat(Long contentId, Macro macro) throws XhtmlException {
        com.atlassian.confluence.macro.Macro realMacro = this.macroManager.getMacroByName(macro.getName());
        if (realMacro == null) {
            throw new RuntimeException("The macro " + macro.getName() + " is not available. Perhaps it has been disabled or removed.");
        }
        MacroBody macroBody = this.getMacroBody(macro, realMacro);
        MacroDefinition macroDefinition = MacroDefinition.builder((String)macro.getName()).withMacroBody(macroBody).withParameters(this.replaceParamNewlinesWithCharacterEntity(macro.getParams())).withStorageVersion("1").withSchemaVersion(this.getSchemaVersion(macro)).build();
        macroDefinition.setDefaultParameterValue(macro.getDefaultParameterValue());
        return this.editorFormatService.convertMacroDefinitionToEdit(macroDefinition, this.getConversionContext(contentId, false, MACRO_PLACEHOLDER_TIMEOUT, MACRO_PLACEHOLDER_TIMEOUT_DEFAULT));
    }

    private void checkUsePermission(ConfluenceUser remoteUser) {
        if (!this.spacePermissionManager.hasPermission("USECONFLUENCE", null, remoteUser)) {
            throw new PermissionException();
        }
    }

    private @Nullable MacroBody getMacroBody(Macro macroEntity, com.atlassian.confluence.macro.Macro realMacro) {
        if (realMacro.getBodyType() == Macro.BodyType.RICH_TEXT) {
            return RichTextMacroBody.withStorage((Streamable)Streamables.from((String)this.storageFormatCleaner.cleanQuietly(macroEntity.getBody())));
        }
        if (realMacro.getBodyType() == Macro.BodyType.PLAIN_TEXT) {
            return new PlainTextMacroBody(macroEntity.getBody());
        }
        return null;
    }

    private int getSchemaVersion(Macro macro) {
        int schemaVersion = macro.getSchemaVersion();
        if (schemaVersion == 0) {
            MacroMetadata metadata = this.macroMetadataManager.getMacroMetadataByName(macro.getName());
            Preconditions.checkState((metadata != null ? 1 : 0) != 0, (Object)("No macro metadata found for macro '" + macro.getName() + "; cannot determine macro schema version"));
            return metadata.getFormDetails().getSchemaVersion();
        }
        return schemaVersion;
    }

    @POST
    @Path(value="/definition")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response generateDefinition(UnmarshalMacroRequest unmarshalMacroRequest) {
        Long contentId = unmarshalMacroRequest.getContentId();
        try {
            this.checkUsePermission(AuthenticatedUserThreadLocal.get());
            String macroXhtml = this.htmlToXmlConverter.convert(unmarshalMacroRequest.getMacroHtml());
            MacroDefinition macroDefinition = this.editorFormatService.convertEditToMacroDefinition(macroXhtml, this.getConversionContext(contentId, false, MACRO_DEFINITION_TIMEOUT, MACRO_DEFINITION_TIMEOUT_DEFAULT));
            Macro macro = MacroResource.buildMacroEntity(macroDefinition);
            macro.setParams(this.replaceParamNewlinesWithCharacterEntity(macro.getParams()));
            return Response.ok((Object)macro).build();
        }
        catch (XhtmlException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (PermissionException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private static Macro buildMacroEntity(MacroDefinition macroDefinition) {
        Macro macro = new Macro();
        macro.setName(macroDefinition.getName());
        macro.setSchemaVersion(macroDefinition.getSchemaVersion());
        macro.setParams(macroDefinition.getParameters());
        macro.setDefaultParameterValue(macroDefinition.getDefaultParameterValue());
        macro.setBody(macroDefinition.getBodyText());
        return macro;
    }

    @POST
    @Path(value="/preview")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response generatePreview(PreviewMacroRequest previewMacroRequest) {
        try {
            this.checkUsePermission(AuthenticatedUserThreadLocal.get());
            String macroName = previewMacroRequest.getMacro().getName();
            com.atlassian.confluence.macro.Macro realMacro = this.macroManager.getMacroByName(macroName);
            String macroPreview = realMacro == null ? this.i18nResolver.getText("tinymce.macro.unknownMacro", new Serializable[]{HtmlUtil.htmlEncode((String)macroName)}) : (String)this.transactionTemplate.execute(() -> {
                try {
                    Macro macro = previewMacroRequest.getMacro();
                    ConversionContext context = this.getConversionContext(previewMacroRequest.getContentId(), true, MACRO_PREVIEW_TIMEOUT, MACRO_PREVIEW_TIMEOUT_DEFAULT);
                    Object macroBody = realMacro.getBodyType() == Macro.BodyType.RICH_TEXT ? this.getRichTextMacroBody(macro, context) : (realMacro.getBodyType() == Macro.BodyType.PLAIN_TEXT ? new PlainTextMacroBody(macro.getBody()) : null);
                    Map typedParameters = this.macroParameterTypeParser.parseMacroParameters(macro.getName(), macro.getParams(), context);
                    MacroDefinition definition = MacroDefinition.builder((String)macro.getName()).withMacroBody(macroBody).withParameters(macro.getParams()).withTypedParameters(typedParameters).withStorageVersion("2").withSchemaVersion(this.getSchemaVersion(macro)).build();
                    definition.setDefaultParameterValue(macro.getDefaultParameterValue());
                    if (macro.getDefaultParameterValue() != null) {
                        definition.setTypedParameter("", this.macroParameterTypeParser.parseMacroParameter(macro.getName(), "", macro.getDefaultParameterValue(), macro.getParams(), context));
                    }
                    return this.xhtmlContent.convertMacroDefinitionToView(definition, context);
                }
                catch (XhtmlException | InvalidMacroParameterException | XMLStreamException e) {
                    return this.i18nResolver.getText("tinymce.macro.preview.exception", new Serializable[]{HtmlUtil.htmlEncode((String)e.getMessage())});
                }
                catch (PermissionException e) {
                    throw new UncheckedExecutionException((Throwable)e);
                }
            });
            Map context = this.velocityHelperService.createDefaultVelocityContext();
            context.put("macroPreview", new HtmlFragment((Object)StringUtils.defaultString((String)macroPreview)));
            context.put("request", this.httpContext.getActiveRequest());
            String output = this.velocityHelperService.getRenderedTemplateWithoutSwallowingErrors("content/render/xhtml/preview-macro-template.vm", context);
            return Response.ok((Object)output).build();
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof PermissionException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            throw e;
        }
        catch (PermissionException p) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MacroBody getRichTextMacroBody(Macro macro, ConversionContext context) throws XMLStreamException, XhtmlException {
        return this.storageMacroBodyParser.getMacroBody(macro.getName(), this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(this.storageFormatCleaner.cleanQuietly(macro.getBody()))), context, this.defaultFragmentTransformer);
    }

    private ConversionContext getConversionContext(Long contentId, boolean isPreview, String timeoutProperty, long timeoutDefault) throws PermissionException {
        PageContext ctx;
        ContentEntityObject contentEntityObject = null;
        if (contentId != null) {
            contentEntityObject = this.contentEntityManager.getById(contentId.longValue());
        }
        long timeoutMillis = Long.getLong(timeoutProperty, timeoutDefault);
        if (contentEntityObject == null) {
            ctx = PageContext.newContextWithTimeout(null, (Timeout)Timeout.getMillisTimeout((long)timeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS));
        } else {
            if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)contentEntityObject)) {
                throw new PermissionException("User " + String.valueOf(AuthenticatedUserThreadLocal.get()) + " does not have permission to view content with id=" + contentId);
            }
            ctx = PageContext.newContextWithTimeout((ContentEntityObject)contentEntityObject, (Timeout)Timeout.getMillisTimeout((long)timeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS));
        }
        if (isPreview) {
            ctx.setOutputType(ConversionContextOutputType.PREVIEW.value());
        }
        return new DefaultConversionContext((RenderContext)ctx);
    }

    private Map<String, String> replaceParamNewlinesWithCharacterEntity(Map<String, String> params) {
        params.replaceAll((k, v) -> v.replace(NEWLINE_CHARACTER, NEWLINE_CHARACTER_ENTITY));
        return params;
    }
}

