/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.content.render.xhtml.RenderedContentCleaner;
import com.atlassian.confluence.tinymceplugin.rest.entities.WikiToXhtmlConversionData;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.ins.InsExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

@Path(value="/markdownxhtmlconverter")
public class MarkdownXhtmlConverter {
    private final RenderedContentCleaner renderedContentCleaner;

    @Inject
    public MarkdownXhtmlConverter(RenderedContentCleaner renderedContentCleaner) {
        this.renderedContentCleaner = renderedContentCleaner;
    }

    @POST
    @AnonymousSiteAccess
    @Consumes(value={"application/json"})
    @Produces(value={"text/html"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response convert(WikiToXhtmlConversionData data) {
        if (data == null || StringUtils.isBlank((CharSequence)data.getWiki()) || data.getEntityId() < 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List<Extension> extensions = Arrays.asList(InsExtension.create(), StrikethroughExtension.create(), TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        HtmlRenderer renderer = HtmlRenderer.builder().extensions(extensions).build();
        Node node = parser.parse(data.getWiki());
        String xhtml = renderer.render(node);
        xhtml = this.renderedContentCleaner.cleanQuietly(xhtml);
        return Response.ok((Object)xhtml).build();
    }
}

