/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.PageTemplateContext;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.tinymceplugin.rest.entities.WikiToXhtmlConversionData;
import com.atlassian.confluence.xhtml.api.EditorFormatService;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.seraph.auth.AuthenticationContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.security.Principal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/wikixhtmlconverter")
public class WikiXhtmlConverter {
    private static final Logger log = LoggerFactory.getLogger(WikiXhtmlConverter.class);
    private static final String TEMPLATE_CONTEXT = "template";
    private final EditorFormatService editorFormatService;
    private final ContentEntityManager contentEntityManager;
    private final PageTemplateManager pageTemplateManager;
    private final SpaceManager spaceManager;
    @Context
    protected AuthenticationContext authContext;

    @Inject
    public WikiXhtmlConverter(EditorFormatService editorFormatService, @Named(value="contentEntityManager") ContentEntityManager contentEntityManager, PageTemplateManager pageTemplateManager, SpaceManager spaceManager) {
        this.editorFormatService = editorFormatService;
        this.contentEntityManager = contentEntityManager;
        this.pageTemplateManager = pageTemplateManager;
        this.spaceManager = spaceManager;
    }

    @POST
    @AnonymousSiteAccess
    @Consumes(value={"application/json"})
    @Produces(value={"text/html"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response convert(WikiToXhtmlConversionData data) {
        PageTemplateContext renderContext;
        if (data == null || StringUtils.isBlank((CharSequence)data.getWiki()) || data.getEntityId() < 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (log.isDebugEnabled()) {
            Principal principal = this.authContext.getUser();
            String userName = "Anonymous";
            if (principal != null) {
                userName = principal.getName();
            }
            log.debug("[{}][{}-{}]\n{}", (Object[])new String[]{userName, data.getSpaceKey(), String.valueOf(data.getEntityId()), data.getWiki()});
        }
        if (TEMPLATE_CONTEXT.equals(data.getContextType())) {
            PageTemplate templateEntity = this.pageTemplateManager.getPageTemplate(data.getEntityId());
            if (templateEntity == null) {
                templateEntity = new PageTemplate();
                templateEntity.setSpace(this.spaceManager.getSpace(data.getSpaceKey()));
            }
            renderContext = new PageTemplateContext(templateEntity);
        } else {
            ContentEntityObject contentEntity = this.contentEntityManager.getById(data.getEntityId());
            if (contentEntity == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Could not find content with contentId: " + data.getEntityId())).build();
            }
            renderContext = new PageContext(contentEntity);
        }
        renderContext.addParam((Object)"DO_LINK_PERMISSION_CHECK", (Object)true);
        if (data.shouldSuppressFirstParagraph()) {
            renderContext.pushRenderMode(RenderMode.suppress((long)256L));
        }
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)renderContext);
        try {
            String xhtml = this.editorFormatService.convertWikiToEdit(data.getWiki(), (ConversionContext)context);
            return Response.ok((Object)xhtml).build();
        }
        catch (XhtmlException ex) {
            throw new RuntimeException(ex);
        }
    }
}

