/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest.captcha;

import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.tinymceplugin.rest.captcha.CaptchaCheckFailedException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;

public class CaptchaResourceFilter
implements ContainerRequestFilter {
    public static final String CAPTCHA_HEADER_ID = "X-Atlassian-Captcha-Id";
    public static final String CAPTCHA_HEADER_RESPONSE = "X-Atlassian-Captcha-Response";
    private final CaptchaManager captchaManager;

    public CaptchaResourceFilter(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }

    public void filter(ContainerRequestContext requestContext) {
        this.filter(requestContext.getHeaderString(CAPTCHA_HEADER_ID), requestContext.getHeaderString(CAPTCHA_HEADER_RESPONSE));
    }

    public void filter(HttpServletRequest req) {
        this.filter(req.getHeader(CAPTCHA_HEADER_ID), req.getHeader(CAPTCHA_HEADER_RESPONSE));
    }

    public void filter(String captchaId, String captchaResponse) throws CaptchaCheckFailedException {
        if (this.captchaManager.isCaptchaEnabled() && !this.captchaManager.validateCaptcha(captchaId, captchaResponse)) {
            throw new CaptchaCheckFailedException();
        }
    }
}

