/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request.bamboo;

import com.atlassian.oauth2.scopes.api.Scope;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Set;

public enum BambooScope implements Scope
{
    READ("READ", Collections.emptySet(), (Set<String>)ImmutableSet.of((Object)"authorization_code", (Object)"client_credentials")),
    WRITE("WRITE", (Set<Scope>)ImmutableSet.of((Object)((Object)READ)), (Set<String>)ImmutableSet.of((Object)"authorization_code", (Object)"client_credentials")),
    READ_ALL("READ_ALL", Collections.emptySet(), (Set<String>)ImmutableSet.of((Object)"client_credentials")),
    TRIGGER("TRIGGER", (Set<Scope>)ImmutableSet.of((Object)((Object)READ)), (Set<String>)ImmutableSet.of((Object)"client_credentials", (Object)"authorization_code")),
    USER("USER", (Set<Scope>)ImmutableSet.of((Object)((Object)TRIGGER), (Object)((Object)READ), (Object)((Object)WRITE)), (Set<String>)ImmutableSet.of((Object)"authorization_code"));

    private final String name;
    private final Set<Scope> inheritedScopes;
    private final Set<String> supportedGrantTypes;

    private BambooScope(String name, Set<Scope> inheritedScopes, Set<String> supportedGrantTypes) {
        this.name = name;
        this.inheritedScopes = ImmutableSet.builder().add((Object)this).addAll(inheritedScopes).build();
        this.supportedGrantTypes = Collections.unmodifiableSet(supportedGrantTypes);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<Scope> getScopeAndInheritedScopes() {
        return this.inheritedScopes;
    }

    public Set<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public String toString() {
        return this.name;
    }
}

