/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request.bamboo;

import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.oauth2.scopes.api.InvalidScopeException;
import com.atlassian.oauth2.scopes.api.Permission;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.oauth2.scopes.request.DefaultScopesRequestCache;
import com.atlassian.oauth2.scopes.request.bamboo.BambooScope;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BambooScopesRequestCache
extends DefaultScopesRequestCache {
    private static final Logger log = LoggerFactory.getLogger(BambooScopesRequestCache.class);
    public static final String SYSADMIN_PERMISSION = "SYSADMIN";

    public BambooScopesRequestCache(ScopeResolver scopeResolver) {
        super(scopeResolver);
    }

    @Override
    protected List<Permission> getPermissions(Scope scope) {
        if (scope == null) {
            return Collections.emptyList();
        }
        try {
            return this.scopeResolver.getScope(scope.getName()).getScopeAndInheritedScopes().stream().map(bambooScope -> switch ((BambooScope)((Object)bambooScope)) {
                default -> throw new MatchException(null, null);
                case BambooScope.READ -> this.readPermissions();
                case BambooScope.READ_ALL -> EMPTY_PERMISSIONS;
                case BambooScope.WRITE -> this.writePermissions();
                case BambooScope.TRIGGER -> this.triggerPermissions();
                case BambooScope.USER -> this.allPermissions();
            }).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        catch (InvalidScopeException e) {
            log.info("Failed to determine scope in request", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<Permission> allPermissions() {
        return Stream.concat(BambooPermission.ALL_PERMISSIONS.stream().map(BambooPermission::getName), Stream.of(SYSADMIN_PERMISSION)).map(Permission::permission).toList();
    }

    private List<Permission> triggerPermissions() {
        return Stream.of(BambooPermission.READ, BambooPermission.BUILD, BambooPermission.CREATE_RELEASE, BambooPermission.SOX_COMPLIANCE).map(BambooPermission::getName).map(Permission::permission).toList();
    }

    private List<Permission> readPermissions() {
        return Stream.of(BambooPermission.READ).map(BambooPermission::getName).map(Permission::permission).toList();
    }

    private List<Permission> writePermissions() {
        return Stream.of(BambooPermission.READ, BambooPermission.WRITE, BambooPermission.CREATE, BambooPermission.DELETE, BambooPermission.ADMINISTRATION, BambooPermission.CLONE, BambooPermission.CREATE_REPOSITORY, BambooPermission.VIEW_CONFIGURATION, BambooPermission.APPROVE_RELEASE, BambooPermission.CREATE_PLAN_BRANCH).map(BambooPermission::getName).map(Permission::permission).toList();
    }
}

