/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request.basic;

import com.atlassian.oauth2.scopes.api.Scope;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public enum BasicScope implements Scope
{
    READ("READ", Collections.emptySet(), (Set<String>)ImmutableSet.of((Object)"authorization_code", (Object)"client_credentials")),
    READ_ALL("READ_ALL", Collections.emptySet(), (Set<String>)ImmutableSet.of((Object)"client_credentials")),
    WRITE("WRITE", (Set<Scope>)ImmutableSet.of((Object)((Object)READ)), (Set<String>)ImmutableSet.of((Object)"authorization_code", (Object)"client_credentials")),
    ADMIN("ADMIN", (Set<Scope>)ImmutableSet.of((Object)((Object)WRITE), (Object)((Object)READ)), (Set<String>)ImmutableSet.of((Object)"authorization_code")),
    SYSTEM_ADMIN("SYSTEM_ADMIN", (Set<Scope>)ImmutableSet.of((Object)((Object)ADMIN), (Object)((Object)WRITE), (Object)((Object)READ)), (Set<String>)ImmutableSet.of((Object)"authorization_code")),
    MANAGE_SUBSCRIPTIONS("MANAGE_SUBSCRIPTIONS", (Set<Scope>)ImmutableSet.of((Object)((Object)READ_ALL), (Object)((Object)READ)), (Set<String>)ImmutableSet.of((Object)"client_credentials")),
    JSM_KB("JSM_KB", (Set<Scope>)ImmutableSet.of((Object)((Object)WRITE), (Object)((Object)READ)), (Set<String>)ImmutableSet.of((Object)"client_credentials"));

    private final String name;
    private final Set<Scope> inheritedScopes;
    private final Set<String> supportedGrantTypes;

    private BasicScope(String name, Set<Scope> inheritedScopes, Set<String> supportedGrantTypes) {
        this.name = name;
        this.inheritedScopes = ImmutableSet.builder().add((Object)this).addAll(inheritedScopes).build();
        this.supportedGrantTypes = Collections.unmodifiableSet(supportedGrantTypes);
    }

    public static Optional<BasicScope> get(Scope scope) {
        return Arrays.stream(BasicScope.values()).filter(basicScope -> basicScope.equals(scope)).findFirst();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<Scope> getScopeAndInheritedScopes() {
        return this.inheritedScopes;
    }

    public Set<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public String toString() {
        return this.name;
    }
}

