/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request.bitbucket;

import com.atlassian.oauth2.scopes.api.Scope;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Set;

public enum BitbucketScope implements Scope
{
    PUBLIC_REPOS("PUBLIC_REPOS", Collections.emptySet(), (Set<String>)ImmutableSet.of((Object)"authorization_code", (Object)"client_credentials")),
    ACCOUNT_WRITE("ACCOUNT_WRITE", (Set<Scope>)ImmutableSet.of((Object)((Object)PUBLIC_REPOS)), (Set<String>)ImmutableSet.of((Object)"authorization_code", (Object)"client_credentials")),
    REPO_READ("REPO_READ", (Set<Scope>)ImmutableSet.of((Object)((Object)PUBLIC_REPOS)), (Set<String>)ImmutableSet.of((Object)"authorization_code", (Object)"client_credentials")),
    REPO_WRITE("REPO_WRITE", (Set<Scope>)ImmutableSet.of((Object)((Object)REPO_READ), (Object)((Object)PUBLIC_REPOS)), (Set<String>)ImmutableSet.of((Object)"authorization_code", (Object)"client_credentials")),
    REPO_ADMIN("REPO_ADMIN", (Set<Scope>)ImmutableSet.of((Object)((Object)REPO_WRITE), (Object)((Object)REPO_READ), (Object)((Object)PUBLIC_REPOS)), (Set<String>)ImmutableSet.of((Object)"authorization_code")),
    PROJECT_ADMIN("PROJECT_ADMIN", (Set<Scope>)ImmutableSet.of((Object)((Object)REPO_ADMIN), (Object)((Object)REPO_WRITE), (Object)((Object)REPO_READ), (Object)((Object)PUBLIC_REPOS)), (Set<String>)ImmutableSet.of((Object)"authorization_code")),
    ADMIN_WRITE("ADMIN_WRITE", (Set<Scope>)ImmutableSet.of((Object)((Object)PROJECT_ADMIN), (Object)((Object)REPO_ADMIN), (Object)((Object)REPO_WRITE), (Object)((Object)REPO_READ), (Object)((Object)ACCOUNT_WRITE), (Object)((Object)PUBLIC_REPOS), (Object[])new Scope[0]), (Set<String>)ImmutableSet.of((Object)"authorization_code")),
    SYSTEM_ADMIN("SYSTEM_ADMIN", (Set<Scope>)ImmutableSet.of((Object)((Object)ADMIN_WRITE), (Object)((Object)PROJECT_ADMIN), (Object)((Object)REPO_ADMIN), (Object)((Object)REPO_WRITE), (Object)((Object)REPO_READ), (Object)((Object)ACCOUNT_WRITE), (Object[])new Scope[]{PUBLIC_REPOS}), (Set<String>)ImmutableSet.of((Object)"authorization_code"));

    private final String name;
    private final Set<Scope> inheritedScopes;
    private final Set<String> supportedGrantTypes;

    private BitbucketScope(String name, Set<Scope> inheritedScopes, Set<String> supportedGrantTypes) {
        this.name = name;
        this.inheritedScopes = ImmutableSet.builder().add((Object)this).addAll(inheritedScopes).build();
        this.supportedGrantTypes = Collections.unmodifiableSet(supportedGrantTypes);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<Scope> getScopeAndInheritedScopes() {
        return this.inheritedScopes;
    }

    public Set<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public String toString() {
        return this.name;
    }
}

