/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request.crowd;

import com.atlassian.crowd.model.permission.UserPermission;
import com.atlassian.oauth2.scopes.api.Permission;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.oauth2.scopes.request.DefaultScopesRequestCache;
import com.atlassian.oauth2.scopes.request.crowd.CrowdScope;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CrowdScopesRequestCache
extends DefaultScopesRequestCache {
    public CrowdScopesRequestCache(ScopeResolver scopeResolver) {
        super(scopeResolver);
    }

    @Override
    protected List<Permission> getPermissions(Scope scope) {
        if (scope == null) {
            return List.of();
        }
        return this.scopeResolver.getScope(scope.getName()).getScopeAndInheritedScopes().stream().flatMap(crowdScope -> switch ((CrowdScope)((Object)crowdScope)) {
            default -> throw new MatchException(null, null);
            case CrowdScope.USER -> this.userPermissions();
            case CrowdScope.SYSTEM_ADMIN -> this.adminPermissions();
            case CrowdScope.APPLICATION -> this.applicationPermissions();
        }).distinct().collect(Collectors.toList());
    }

    private Stream<Permission> applicationPermissions() {
        return Stream.of(Permission.permission((String)UserPermission.SYS_ADMIN.name()));
    }

    private Stream<Permission> adminPermissions() {
        return Stream.of(Permission.permission((String)UserPermission.SYS_ADMIN.name()));
    }

    private Stream<Permission> userPermissions() {
        return Stream.of(Permission.permission((String)""));
    }
}

