/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request.custom;

import com.atlassian.oauth2.scopes.request.custom.CustomPermission;
import com.atlassian.oauth2.scopes.request.custom.CustomPermissionDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPermissionMapperService {
    private static final Logger logger = LoggerFactory.getLogger(CustomPermissionMapperService.class);
    private Set<CustomPermission> customPermissions = new HashSet<CustomPermission>();
    private final Set<String> definedPermissions = new HashSet<String>();
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;

    public CustomPermissionMapperService(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
        this.refreshCustomPermissionMap();
    }

    @PostConstruct
    public void postConstruct() {
        this.pluginEventManager.register((Object)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    public void refreshCustomPermissionMap() {
        this.customPermissions = this.pluginAccessor.getEnabledPlugins().stream().flatMap(plugin -> plugin.getModuleDescriptors().stream()).filter(moduleDescriptor -> moduleDescriptor instanceof CustomPermissionDescriptor).map(this::parseCustomPermissions).filter(Optional::isPresent).flatMap(optional -> ((Set)optional.get()).stream()).collect(Collectors.toSet());
    }

    private void addPermission(Set<CustomPermission> customPermissionList) {
        customPermissionList.forEach(customPermission -> {
            if (!this.definedPermissions.add(customPermission.getPermissionKey())) {
                logger.error("Permission key already defined: " + customPermission.getPermissionKey());
            }
            this.customPermissions.add((CustomPermission)customPermission);
        });
    }

    private void removePermission(Set<CustomPermission> customPermissionList) {
        customPermissionList.forEach(customPermission -> {
            this.definedPermissions.remove(customPermission.getPermissionKey());
            this.customPermissions.remove(customPermission);
        });
    }

    @PluginEventListener
    public void removePermissionEvent(PluginModuleDisabledEvent event) {
        ModuleDescriptor moduleDescriptor = event.getModule();
        if (moduleDescriptor instanceof CustomPermissionDescriptor) {
            logger.debug("PluginModule disabled event detected - removing permission mapping");
            this.removePermission((Set)moduleDescriptor.getModule());
        }
    }

    @PluginEventListener
    public void addPermissionEvent(PluginModuleEnabledEvent event) {
        ModuleDescriptor moduleDescriptor = event.getModule();
        if (moduleDescriptor instanceof CustomPermissionDescriptor) {
            logger.debug("PluginModule enabled event detected - adding permission mapping");
            this.addPermission((Set)moduleDescriptor.getModule());
        }
    }

    private Optional<Set<CustomPermission>> parseCustomPermissions(ModuleDescriptor<?> customPermissionModuleDescriptor) {
        if (customPermissionModuleDescriptor instanceof CustomPermissionDescriptor) {
            return Optional.of((Set)customPermissionModuleDescriptor.getModule());
        }
        logger.error("Invalid module descriptor type: " + customPermissionModuleDescriptor.getClass().getName());
        return Optional.empty();
    }

    public Map<String, Set<String>> getScopeMappings() {
        return this.customPermissions.stream().collect(Collectors.groupingBy(CustomPermission::getScope, Collectors.mapping(CustomPermission::getPermissionKey, Collectors.toSet())));
    }
}

