/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist2;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import java.util.Date;

public class DateRenderer {
    private final UserPreferencesAccessor userAccessor;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;

    public DateRenderer(UserPreferencesAccessor userAccessor, FormatSettingsManager formatSettingsManager, LocaleManager localeManager) {
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
    }

    public String render(long time, boolean showTime) {
        if (time == 0L) {
            return "N/A";
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        TimeZone tz = this.userAccessor.getUserPreferences(user).getTimeZone();
        DateFormatter formatter = new DateFormatter(tz, this.formatSettingsManager, this.localeManager);
        if (showTime) {
            return formatter.formatDateTime(new Date(time));
        }
        return formatter.format(new Date(time));
    }
}

