/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist2.model;

import com.atlassian.confluence.extra.dynamictasklist2.model.TaskList;
import com.atlassian.confluence.extra.dynamictasklist2.util.Base32;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TaskListId {
    private final int occurrence;
    private final String listName;

    public TaskListId(String listName, int occurrence) {
        if (occurrence < 1) {
            throw new IllegalArgumentException("occurrence must be a positive integer");
        }
        this.listName = StringUtils.defaultString((String)listName);
        this.occurrence = occurrence;
    }

    public TaskListId(String listId) {
        if (StringUtils.isBlank((CharSequence)listId)) {
            throw new IllegalArgumentException("listId cannot be null or blank");
        }
        int occurrenceSeparatorIndex = listId.indexOf(":");
        if (occurrenceSeparatorIndex == -1) {
            throw new IllegalArgumentException("listId not correctly formatted. Missing separator character: ':'");
        }
        this.occurrence = TaskList.getOccuranceFromId(listId);
        this.listName = occurrenceSeparatorIndex < listId.length() - 1 ? new String(Base32.decode(listId.substring(occurrenceSeparatorIndex + 1)), StandardCharsets.UTF_8) : "";
    }

    public int getOccurrence() {
        return this.occurrence;
    }

    public String getListName() {
        return this.listName;
    }

    public String toString() {
        return this.occurrence + ":" + Base32.encode(this.listName.getBytes(StandardCharsets.UTF_8));
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }
}

