/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.impl.cache.CacheCompactorSupport;
import com.google.common.base.Stopwatch;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.statistics.StatisticsGateway;
import net.sf.ehcache.statistics.extended.ExtendedStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Internal
class EhCacheCompactor
extends CacheCompactorSupport {
    private static final Logger log = LoggerFactory.getLogger(EhCacheCompactor.class);
    public static final boolean STATS_COMPACTION_ENABLED = Boolean.getBoolean("ehcache.stats.compaction");
    private static final long ELAPSED_MILLIS_WARN_THRESHOLD = 1000L;
    private final ResettableLazyReference<CacheManager> cacheManagerRef;

    EhCacheCompactor(ResettableLazyReference<CacheManager> cacheManagerRef) {
        this.cacheManagerRef = Objects.requireNonNull(cacheManagerRef);
    }

    public void compact() {
        if (this.cacheManagerIsRunning()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int numberOfCaches = this.performEviction();
            long elapsedMillis = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (elapsedMillis > 1000L) {
                log.warn("Completed compaction on {} caches in {} ms", (Object)numberOfCaches, (Object)elapsedMillis);
            } else {
                log.debug("Completed compaction on {} caches in {} ms", (Object)numberOfCaches, (Object)elapsedMillis);
            }
        } else {
            log.debug("CacheManager is not alive, or dark feature is not enabled; skipping compaction");
        }
    }

    private int performEviction() {
        CacheManager cacheManager = (CacheManager)this.cacheManagerRef.get();
        String[] cacheNames = cacheManager.getCacheNames();
        log.debug("Starting compaction for all {} caches", (Object)cacheNames.length);
        for (String cacheName : cacheNames) {
            this.evictExpiredElements(cacheManager.getEhcache(cacheName));
        }
        return cacheNames.length;
    }

    private boolean cacheManagerIsRunning() {
        return this.cacheManagerRef.isInitialized() && ((CacheManager)this.cacheManagerRef.get()).getStatus() == Status.STATUS_ALIVE;
    }

    private void evictExpiredElements(Ehcache cache) {
        if (log.isDebugEnabled()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            int noOfElementsBefore = cache.getSize();
            cache.evictExpiredElements();
            int noOfElementsAfter = cache.getSize();
            log.debug("Evicted elements from cache [{}] in {} ms ({} elements before, {} after)", new Object[]{cache.getName(), stopwatch.elapsed(TimeUnit.MILLISECONDS), noOfElementsBefore, noOfElementsAfter});
        } else {
            cache.evictExpiredElements();
        }
        if (STATS_COMPACTION_ENABLED) {
            StatisticsGateway statisticsGateway = cache.getStatistics();
            ExtendedStatistics extended = statisticsGateway.getExtended();
            EhCacheCompactor.flushStats(extended, "standardOperations");
            EhCacheCompactor.flushStats(extended, "customOperations");
            EhCacheCompactor.flushStats(extended, "customPassthrus");
        }
    }

    public static void flushStats(ExtendedStatistics extendedStatistics, String statsName) {
        try {
            Field f = extendedStatistics.getClass().getDeclaredField(statsName);
            f.setAccessible(true);
            ConcurrentMap statsHolder = (ConcurrentMap)f.get(extendedStatistics);
            log.debug("Flushing [{}] operations from {}", (Object)statsHolder.size(), (Object)statsName);
            statsHolder.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

